/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game;

import io.github.mal32.endergames.EnderGames;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Biome;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class WorldManager {
    private final World world = Objects.requireNonNull(Bukkit.getWorld((String)"world"));
    private final NamespacedKey spawnLocationKey;
    private Location spawnLocation;

    public WorldManager(EnderGames plugin) {
        this.spawnLocationKey = new NamespacedKey((Plugin)plugin, "spawnLocation");
        WorldBorder border = this.world.getWorldBorder();
        border.setWarningDistance(32);
        border.setWarningTime(60);
        border.setDamageBuffer(1.0);
        this.world.setStorm(false);
        this.world.setThundering(false);
        this.world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
        this.world.setGameRule(GameRule.LOCATOR_BAR, (Object)false);
        this.world.setGameRule(GameRule.DO_INSOMNIA, (Object)false);
        this.world.setDifficulty(Difficulty.EASY);
        if (!this.world.getPersistentDataContainer().has(this.spawnLocationKey)) {
            plugin.getComponentLogger().info("Creating spawn location");
            this.spawnLocation = new Location(this.world, 0.0, 200.0, 0.0);
            this.findAndSaveNewSpawnLocation();
        } else {
            this.loadSpawnLocation();
        }
    }

    private static boolean isOcean(Biome biome) {
        return biome.equals((Object)Biome.DEEP_FROZEN_OCEAN) || biome.equals((Object)Biome.DEEP_COLD_OCEAN) || biome.equals((Object)Biome.DEEP_OCEAN) || biome.equals((Object)Biome.DEEP_LUKEWARM_OCEAN) || biome.equals((Object)Biome.FROZEN_OCEAN) || biome.equals((Object)Biome.OCEAN) || biome.equals((Object)Biome.COLD_OCEAN) || biome.equals((Object)Biome.LUKEWARM_OCEAN) || biome.equals((Object)Biome.WARM_OCEAN);
    }

    public Location getSpawnLocation() {
        return this.spawnLocation;
    }

    private void saveSpawnLocation() {
        this.world.getPersistentDataContainer().set(this.spawnLocationKey, PersistentDataType.INTEGER, (Object)this.spawnLocation.getBlockX());
    }

    private void loadSpawnLocation() {
        double rawSpawnX = ((Integer)this.world.getPersistentDataContainer().get(this.spawnLocationKey, PersistentDataType.INTEGER)).intValue();
        this.spawnLocation = new Location(this.world, rawSpawnX, 200.0, 0.0);
    }

    public void findAndSaveNewSpawnLocation() {
        do {
            this.spawnLocation.add(1000.0, 0.0, 0.0);
            this.spawnLocation.getChunk().load(true);
        } while (WorldManager.isOcean(this.spawnLocation.getBlock().getBiome()));
        this.saveSpawnLocation();
        this.world.getWorldBorder().setCenter(this.spawnLocation);
    }
}

