/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game.game;

import io.github.mal32.endergames.EnderGames;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.plugin.Plugin;

public abstract class AbstractTeleportingBlock {
    protected Location location;
    public boolean hasBeenUsed = false;
    protected boolean hasBeenOpened = false;
    private final EnderGames plugin;

    public AbstractTeleportingBlock(EnderGames plugin, Location location) {
        this.location = location;
        this.plugin = plugin;
    }

    public void teleport(Location location) {
        this.destroy();
        this.location = location;
        this.place();
        this.hasBeenUsed = false;
        this.hasBeenOpened = false;
    }

    public void place() {
        if (!this.location.getChunk().isLoaded()) {
            this.location.getChunk().load();
        }
        World world = this.location.getWorld();
        Location blockSpawnLocation = this.location.getBlock().getLocation().clone();
        blockSpawnLocation.setY(256.0);
        FallingBlock fallingBlock = (FallingBlock)world.spawnEntity(blockSpawnLocation, EntityType.FALLING_BLOCK);
        fallingBlock.setCancelDrop(true);
        fallingBlock.setBlockData(Bukkit.createBlockData((Material)this.getFallingBlockMaterial()));
        Block block = world.getBlockAt(this.location);
        block.setType(this.getBlockMaterial());
        this.playTeleportEffects();
    }

    public void destroy() {
        if (!this.location.getChunk().isLoaded()) {
            this.location.getChunk().load();
        }
        if (this.location.getBlock().getType() != this.getBlockMaterial()) {
            return;
        }
        this.location.getWorld().getBlockAt(this.location).setType(Material.AIR);
        this.playTeleportEffects();
    }

    public void open() {
        if (this.hasBeenOpened) {
            return;
        }
        this.hasBeenOpened = true;
        int TELEPORT_BLOCK_TIME_SECONDS = 10;
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.hasBeenUsed = true;
        }, 200L);
    }

    private void playTeleportEffects() {
        this.location.getWorld().playSound(this.location, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 0.5f);
        this.location.getWorld().spawnParticle(Particle.PORTAL, this.location.getBlock().getLocation().clone().add(0.5, 0.5, 0.5), 50, 0.0, 0.0, 0.0);
    }

    public abstract Material getBlockMaterial();

    public abstract Material getFallingBlockMaterial();

    public Location getLocation() {
        return this.location;
    }
}

