/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game.game;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.worlds.game.GameWorld;
import io.github.mal32.endergames.worlds.game.game.AbstractTask;
import io.github.mal32.endergames.worlds.game.game.AbstractTeleportingBlock;
import io.github.mal32.endergames.worlds.game.game.BlockRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Player;

public abstract class AbstractTeleportingBlockManager<B extends AbstractTeleportingBlock>
extends AbstractTask {
    protected final ArrayList<B> blocks = new ArrayList();
    private int nextIndex = 0;
    protected final Location spawnLocation;

    public AbstractTeleportingBlockManager(EnderGames plugin, Location spawnLocation) {
        super(plugin);
        this.spawnLocation = spawnLocation;
        int playerCount = GameWorld.getPlayersInGame().length;
        Location startLocation = spawnLocation.clone();
        startLocation.setY(0.0);
        for (int i = 0; i < playerCount * this.blocksPerPlayer(); ++i) {
            this.blocks.add(this.getNewBlock(startLocation));
        }
    }

    protected abstract int blocksPerPlayer();

    protected abstract B getNewBlock(Location var1);

    @Override
    public void task() {
        if (this.blocks.isEmpty()) {
            return;
        }
        B block = this.chooseBlock();
        Location horizontalLocation = this.getRandomHorizontalLocation();
        int y = horizontalLocation.getWorld().getHighestBlockAt(horizontalLocation, HeightMap.OCEAN_FLOOR).getY();
        horizontalLocation.setY((double)(y + 1));
        ((AbstractTeleportingBlock)block).teleport(horizontalLocation);
    }

    private B chooseBlock() {
        ArrayList<AbstractTeleportingBlock> usedBlocks = new ArrayList<AbstractTeleportingBlock>();
        for (AbstractTeleportingBlock b : this.blocks) {
            if (!b.hasBeenUsed) continue;
            usedBlocks.add(b);
        }
        ArrayList<Object> chosenBlocks = usedBlocks.isEmpty() ? this.blocks : usedBlocks;
        this.nextIndex %= chosenBlocks.size();
        AbstractTeleportingBlock block = (AbstractTeleportingBlock)chosenBlocks.get(this.nextIndex);
        ++this.nextIndex;
        return (B)block;
    }

    protected Location getRandomHorizontalLocation() {
        int MIN_PLAYER_DISTANCE = 48;
        int MAX_PLAYER_DISTANCE = 96;
        World world = Objects.requireNonNull(Bukkit.getWorld((String)"world"));
        ArrayList<Chunk> loadedChunks = new ArrayList<Chunk>(Arrays.asList(world.getLoadedChunks()));
        Chunk targetChunk = null;
        while (targetChunk == null) {
            int randomIndex = new Random().nextInt(loadedChunks.size());
            Chunk chunk = loadedChunks.get(randomIndex);
            loadedChunks.remove(randomIndex);
            Location chunkBlockLocation = chunk.getBlock(0, 0, 0).getLocation();
            double minHorizontalDistance = AbstractTeleportingBlockManager.getMinHorizontalDistanceToPlayers(chunkBlockLocation);
            if (!(minHorizontalDistance > 48.0) || !(minHorizontalDistance < 96.0)) continue;
            targetChunk = chunk;
        }
        int xOffset = new Random().nextInt(16);
        int zOffset = new Random().nextInt(16);
        return targetChunk.getBlock(xOffset, 0, zOffset).getLocation();
    }

    private static double getMinHorizontalDistanceToPlayers(Location chunkBlockLocation) {
        double minHorizontalDistance = Double.MAX_VALUE;
        for (Player player : GameWorld.getPlayersInGame()) {
            Location playerLocation = player.getLocation();
            double horizontalDistance = Math.sqrt(Math.pow(playerLocation.getBlockX() - chunkBlockLocation.getBlockX(), 2.0) + Math.pow(playerLocation.getBlockZ() - chunkBlockLocation.getBlockZ(), 2.0));
            if (!(horizontalDistance < minHorizontalDistance)) continue;
            minHorizontalDistance = horizontalDistance;
        }
        return minHorizontalDistance;
    }

    public static <T extends BlockRange> T chooseOnWeight(List<T> items) {
        double totalWeight = 0.0;
        for (BlockRange item : items) {
            totalWeight += (double)item.weight();
        }
        double r = Math.random() * totalWeight;
        double cumulativeWeight = 0.0;
        for (BlockRange item : items) {
            if (!((cumulativeWeight += (double)item.weight()) >= r)) continue;
            return (T)item;
        }
        throw new RuntimeException("Should never be shown.");
    }

    private Location getRandomHorizontalBorderLocation(World world, WorldBorder border, Random random) {
        Location center = border.getCenter();
        double halfSize = border.getSize() / 2.0;
        for (int i = 0; i < 10; ++i) {
            double z;
            double xOffset = random.nextDouble() * halfSize * 2.0 - halfSize;
            double zOffset = random.nextDouble() * halfSize * 2.0 - halfSize;
            double x = center.getX() + xOffset;
            Location candidate = new Location(world, x, 0.0, z = center.getZ() + zOffset);
            if (!border.isInside(candidate)) continue;
            return candidate;
        }
        return new Location(world, center.getX(), 0.0, center.getZ());
    }

    @Override
    public int getDelayTicks() {
        return this.getBlockTeleportDelayTicks() / this.blocks.size();
    }

    abstract int getBlockTeleportDelayTicks();

    protected B getBlockAtLocation(Location location) {
        for (AbstractTeleportingBlock b : this.blocks) {
            if (b.getLocation().getBlockX() != location.getBlockX() || b.getLocation().getBlockZ() != location.getBlockZ() || b.getLocation().getBlockY() != location.getBlockY()) continue;
            return (B)b;
        }
        return null;
    }
}

