/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game.game;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.worlds.game.game.AbstractTeleportingBlockManager;
import io.github.mal32.endergames.worlds.game.game.Enchanter;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.EnchantingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EnchanterManager
extends AbstractTeleportingBlockManager<Enchanter> {
    public EnchanterManager(EnderGames plugin, Location spawnLocation) {
        super(plugin, spawnLocation);
    }

    @Override
    public int getBlockTeleportDelayTicks() {
        return 1000;
    }

    @Override
    protected int blocksPerPlayer() {
        return 5;
    }

    @Override
    protected Enchanter getNewBlock(Location location) {
        return new Enchanter(this.plugin, location);
    }

    @EventHandler
    public void onEnchanterOpen(InventoryOpenEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof EnchantingInventory)) {
            return;
        }
        EnchantingInventory inventory2 = (EnchantingInventory)inventory;
        inventory2.setSecondary(new ItemStack(Material.LAPIS_LAZULI, 64));
        Location location = event.getInventory().getLocation();
        if (location == null) {
            return;
        }
        Enchanter enchanter = (Enchanter)this.getBlockAtLocation(location);
        if (enchanter != null) {
            enchanter.open();
        }
    }

    @EventHandler
    public void onEnchanterClickLapis(InventoryClickEvent event) {
        if (!(event.getInventory() instanceof EnchantingInventory)) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() != Material.LAPIS_LAZULI) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onEnchanterClose(InventoryCloseEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof EnchantingInventory)) {
            return;
        }
        EnchantingInventory inventory2 = (EnchantingInventory)inventory;
        ItemStack item = inventory2.getSecondary();
        if (item == null || item.getType() != Material.LAPIS_LAZULI) {
            return;
        }
        item.setAmount(0);
    }
}

