/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game.game;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.worlds.game.game.AbstractTeleportingBlock;
import java.util.ArrayList;
import java.util.Random;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.jetbrains.annotations.NotNull;

class EnderChest
extends AbstractTeleportingBlock
implements InventoryHolder {
    private final Inventory inventory;

    public EnderChest(EnderGames plugin, Location location) {
        super(plugin, location);
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 27, (Component)Component.text((String)"Ender Chest"));
    }

    @Override
    public void teleport(Location location) {
        super.teleport(location);
        new ArrayList<HumanEntity>(this.inventory.getViewers()).forEach(HumanEntity::closeInventory);
    }

    public void prepareInventoryForOpen(Player player) {
        if (this.hasBeenOpened) {
            return;
        }
        this.inventory.clear();
        float luck = (float)player.getAttribute(Attribute.LUCK).getValue();
        LootContext.Builder lootContextBuilder = new LootContext.Builder(this.location).luck(luck);
        LootContext lootContext = lootContextBuilder.build();
        LootTable lootTable = Bukkit.getLootTable((NamespacedKey)new NamespacedKey("enga", "ender_chest"));
        lootTable.fillInventory(this.inventory, new Random(), lootContext);
        this.open();
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public Material getBlockMaterial() {
        return Material.ENDER_CHEST;
    }

    @Override
    public Material getFallingBlockMaterial() {
        return Material.OBSIDIAN;
    }
}

