/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game.game;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.worlds.game.game.AbstractTeleportingBlockManager;
import io.github.mal32.endergames.worlds.game.game.EnderChest;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class EnderChestManager
extends AbstractTeleportingBlockManager<EnderChest> {
    public EnderChestManager(EnderGames plugin, Location spawnLocation) {
        super(plugin, spawnLocation);
    }

    @Override
    public int getBlockTeleportDelayTicks() {
        return 900;
    }

    @Override
    protected int blocksPerPlayer() {
        return 5;
    }

    @Override
    protected EnderChest getNewBlock(Location location) {
        return new EnderChest(this.plugin, location);
    }

    @EventHandler
    private void onEnderChestInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getClickedBlock() == null || event.getClickedBlock().getType() != Material.ENDER_CHEST) {
            return;
        }
        Location blockLocation = event.getClickedBlock().getLocation().clone();
        EnderChest enderChest = (EnderChest)this.getBlockAtLocation(blockLocation);
        if (enderChest == null) {
            enderChest = new EnderChest(this.plugin, blockLocation);
            this.blocks.add(enderChest);
        }
        enderChest.prepareInventoryForOpen(event.getPlayer());
        EnderChest finalEnderChest = enderChest;
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> event.getPlayer().openInventory(finalEnderChest.getInventory()));
    }
}

