/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game.game;

import io.github.mal32.endergames.AbstractModule;
import io.github.mal32.endergames.EnderGames;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class FightDetection
extends AbstractModule {
    private static final Map<UUID, Integer> fightTimestamps = new ConcurrentHashMap<UUID, Integer>();
    private static final long FIGHT_THRESHOLD_SECONDS = 10L;

    public FightDetection(EnderGames plugin) {
        super(plugin);
    }

    public static boolean playerIsInFight(Player player) {
        Integer lastHit = fightTimestamps.get(player.getUniqueId());
        if (lastHit == null) {
            return false;
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        return (long)(now - lastHit) <= 10L;
    }

    @EventHandler
    private void onPlayerDamage(EntityDamageByEntityEvent event) {
        Player target;
        Entity entity;
        block5: {
            block4: {
                entity = event.getEntity();
                if (!(entity instanceof Player)) break block4;
                target = (Player)entity;
                entity = event.getDamager();
                if (entity instanceof Player) break block5;
            }
            return;
        }
        Player damager = (Player)entity;
        if (!EnderGames.playerIsInGameWorld(target) || !EnderGames.playerIsInGameWorld(damager)) {
            return;
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        UUID targetId = target.getUniqueId();
        UUID damagerId = damager.getUniqueId();
        fightTimestamps.put(targetId, now);
        fightTimestamps.put(damagerId, now);
    }
}

