/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game.game;

import io.github.mal32.endergames.AbstractModule;
import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.worlds.game.AbstractPhase;
import io.github.mal32.endergames.worlds.game.GameWorld;
import io.github.mal32.endergames.worlds.game.game.EnchanterManager;
import io.github.mal32.endergames.worlds.game.game.EnderChestManager;
import io.github.mal32.endergames.worlds.game.game.FightDetection;
import io.github.mal32.endergames.worlds.game.game.PlayerRegenerationManager;
import io.github.mal32.endergames.worlds.game.game.PlayerSwapManager;
import io.github.mal32.endergames.worlds.game.game.PotionEffectsStacking;
import io.github.mal32.endergames.worlds.game.game.SmithingTemplateManager;
import io.github.mal32.endergames.worlds.game.game.SpectatorParticles;
import io.github.mal32.endergames.worlds.game.game.SpeedObsidianManager;
import io.github.mal32.endergames.worlds.game.game.SwapperItem;
import io.github.mal32.endergames.worlds.game.game.Tracker;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class GamePhase
extends AbstractPhase {
    private final List<AbstractModule> modules;
    private final List<AbstractKit> kits;

    public GamePhase(EnderGames plugin, GameWorld manager, Location spawnLocation) {
        super(plugin, manager, spawnLocation);
        this.kits = AbstractKit.getKits(plugin);
        this.modules = List.of(new EnchanterManager(plugin, spawnLocation), new EnderChestManager(plugin, spawnLocation), new PlayerRegenerationManager(plugin), new PlayerSwapManager(plugin), new SwapperItem(plugin), new SmithingTemplateManager(plugin), new SpectatorParticles(plugin), new Tracker(plugin), new SpeedObsidianManager(plugin, spawnLocation), new FightDetection(plugin), new PotionEffectsStacking(plugin));
        ArrayList<NamespacedKey> allRecipeKeys = new ArrayList<NamespacedKey>();
        Iterator it = Bukkit.recipeIterator();
        while (it.hasNext()) {
            Recipe recipe = (Recipe)it.next();
            if (!(recipe instanceof Keyed)) continue;
            allRecipeKeys.add(((Keyed)recipe).getKey());
        }
        for (Recipe player : GameWorld.getPlayersInGame()) {
            player.setGameMode(GameMode.SURVIVAL);
            player.discoverRecipes(allRecipeKeys);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("loot give " + player.getName() + " loot enga:tracker"));
            String playerKit = (String)player.getPersistentDataContainer().get(new NamespacedKey((Plugin)plugin, "kit"), PersistentDataType.STRING);
            for (AbstractKit kit : this.kits) {
                if (!Objects.equals(kit.getNameLowercase(), playerKit)) continue;
                kit.start((Player)player);
            }
        }
        WorldBorder worldBoarder = spawnLocation.getWorld().getWorldBorder();
        worldBoarder.setSize(50.0, 1200L);
        worldBoarder.setWarningDistance(32);
        worldBoarder.setWarningTime(60);
        worldBoarder.setDamageBuffer(1.0);
        int spawnPlatformRemoveDelaySeconds = EnderGames.isInDebugMode() ? 600 : 30;
        plugin.getServer().getScheduler().runTaskLater((Plugin)plugin, this::removeSpawnPlatform, (long)(spawnPlatformRemoveDelaySeconds * 20));
        this.initProtectionTime();
        for (AbstractModule module : this.modules) {
            module.enable();
        }
        for (AbstractKit kit : this.kits) {
            kit.enable();
        }
    }

    private void removeSpawnPlatform() {
        for (int x = this.spawnLocation.blockX() - 20; x <= this.spawnLocation.blockX() + 20; ++x) {
            for (int z = this.spawnLocation.blockZ() - 20; z <= this.spawnLocation.blockZ() + 20; ++z) {
                for (int y = this.spawnLocation.blockY() - 5; y <= this.spawnLocation.blockY() + 5; ++y) {
                    this.spawnLocation.getWorld().getBlockAt(x, y, z).setType(Material.AIR);
                }
            }
        }
    }

    private void initProtectionTime() {
        int protectionTimeDurationSeconds = 180;
        BossBar protectionTimeBar = Bukkit.createBossBar((String)"Protection Time", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SEGMENTED_6, (BarFlag[])new BarFlag[0]);
        protectionTimeBar.setProgress(0.0);
        for (int i = 0; i < 180; i += 10) {
            double progress = 1.0 - (double)i / 180.0;
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> protectionTimeBar.setProgress(progress), (long)i * 20L);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> ((BossBar)protectionTimeBar).removeAll(), 3600L);
        for (Player player : GameWorld.getPlayersInGame()) {
            protectionTimeBar.addPlayer(player);
            player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 3600, 4, true, false));
        }
    }

    @Override
    public void disable() {
        super.disable();
        for (AbstractModule module : this.modules) {
            module.disable();
        }
        for (AbstractKit kit : this.kits) {
            kit.disable();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void onPlayerDeath(EntityDamageEvent event) {
        EntityDamageByEntityEvent ede;
        Entity entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player attackedPlayer = (Player)entity2;
        if (!GameWorld.playerIsInGame(attackedPlayer)) {
            return;
        }
        double damage = event.getFinalDamage();
        if (attackedPlayer.getHealth() - damage > 0.0) {
            return;
        }
        event.setCancelled(true);
        Player attackingPlayer = null;
        if (event instanceof EntityDamageByEntityEvent && (entity = (ede = (EntityDamageByEntityEvent)event).getDamager()) instanceof Player) {
            Player d;
            attackingPlayer = d = (Player)entity;
            attackedPlayer.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"").append(Component.text((String)attackingPlayer.getName()).color((TextColor)NamedTextColor.DARK_RED))).append(Component.text((String)" has ").color((TextColor)NamedTextColor.RED))).append(Component.text((String)(String.format("%.2f", attackingPlayer.getHealth()) + "\u2764")).color((TextColor)NamedTextColor.DARK_RED))).append(Component.text((String)" left").color((TextColor)NamedTextColor.RED)));
        }
        this.abstractPlayerDeath(attackedPlayer, attackingPlayer);
    }

    @EventHandler
    private void onPlayerQuit(PlayerQuitEvent event) {
        if (!GameWorld.playerIsInGame(event.getPlayer())) {
            return;
        }
        this.abstractPlayerDeath(event.getPlayer(), null);
    }

    private void abstractPlayerDeath(Player deadPlayer, @Nullable Player attackingPlayer) {
        if (attackingPlayer != null) {
            this.plugin.getComponentLogger().info(deadPlayer.getName() + " died from \"" + attackingPlayer.getName() + "\"");
        } else {
            this.plugin.getComponentLogger().info(deadPlayer.getName() + " died");
        }
        this.resetPlayer(deadPlayer);
        for (Player p : GameWorld.getPlayersInGameWorld()) {
            deadPlayer.playSound((Entity)p, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if (attackingPlayer == null) {
            Bukkit.getServer().sendMessage(((TextComponent)Component.text((String)"").append(Component.text((String)"\u2620 ").color((TextColor)NamedTextColor.DARK_RED))).append(Component.text((String)deadPlayer.getName()).color((TextColor)NamedTextColor.RED)));
        } else {
            Bukkit.getServer().sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"").append(Component.text((String)"\u2620 ").color((TextColor)NamedTextColor.DARK_RED))).append(Component.text((String)deadPlayer.getName()).color((TextColor)NamedTextColor.RED))).append(Component.text((String)" was killed by ").color((TextColor)NamedTextColor.DARK_RED))).append(Component.text((String)attackingPlayer.getName()).color((TextColor)NamedTextColor.RED)));
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            boolean moreThanOnePlayersAlive = GameWorld.getPlayersInGame().length > 1;
            this.plugin.getComponentLogger().info("Players alive: " + moreThanOnePlayersAlive);
            if (!moreThanOnePlayersAlive) {
                this.gameEnd();
            }
        });
    }

    private void resetPlayer(Player player) {
        World world = player.getWorld();
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() == Material.COMPASS) continue;
            world.dropItem(player.getLocation(), item);
        }
        player.getInventory().clear();
        while (player.getLevel() > 0) {
            ExperienceOrb orb = (ExperienceOrb)world.spawnEntity(player.getLocation(), EntityType.EXPERIENCE_ORB);
            orb.setExperience(player.getExpToLevel());
            player.setLevel(player.getLevel() - 1);
        }
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        player.setGameMode(GameMode.SPECTATOR);
        player.setHealth(20.0);
    }

    private void gameEnd() {
        Title title;
        Player[] survivalPlayers;
        for (Player p : survivalPlayers = GameWorld.getPlayersInGame()) {
            this.resetPlayer(p);
        }
        if (survivalPlayers.length >= 1) {
            Player lastPlayer = survivalPlayers[0];
            title = Title.title((Component)Component.text((String)(lastPlayer.getName() + " has Won!")).color((TextColor)NamedTextColor.GOLD), (Component)Component.text((String)""), (Title.Times)Title.Times.times((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(1L)));
            lastPlayer.playSound((Entity)lastPlayer, Sound.UI_TOAST_CHALLENGE_COMPLETE, SoundCategory.MASTER, 1.0f, 1.0f);
        } else {
            title = Title.title((Component)Component.text((String)"Draw").color((TextColor)NamedTextColor.GOLD), (Component)Component.text((String)""), (Title.Times)Title.Times.times((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(1L)));
        }
        for (Player player : GameWorld.getPlayersInGameWorld()) {
            player.showTitle(title);
        }
        this.manager.nextPhase();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void onPlayerPlaceTNT(BlockPlaceEvent event) {
        if (!GameWorld.playerIsInGame(event.getPlayer())) {
            return;
        }
        if (event.getBlock().getType() != Material.TNT) {
            return;
        }
        if (event.getPlayer().isSneaking()) {
            return;
        }
        Block block = event.getBlock();
        block.setType(Material.AIR);
        TNTPrimed tnt = (TNTPrimed)block.getWorld().spawnEntity(block.getLocation().clone().add(0.5, 0.0, 0.5), EntityType.TNT);
        tnt.setFuseTicks(30);
    }

    @EventHandler
    public void onPlayerArrowClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (!GameWorld.playerIsInGame(player)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.ARROW && item.getType() != Material.SPECTRAL_ARROW) {
            return;
        }
        item.setAmount(item.getAmount() - 1);
        double speedMultiplier = 1.2;
        Vector direction = player.getEyeLocation().getDirection();
        Vector customVelocity = direction.normalize().multiply(1.2);
        Class arrowClass = item.getType() == Material.ARROW ? Arrow.class : SpectralArrow.class;
        AbstractArrow arrow = (AbstractArrow)event.getPlayer().launchProjectile(arrowClass, customVelocity);
        arrow.setShooter((ProjectileSource)event.getPlayer());
        arrow.setDamage(1.0);
    }

    @EventHandler
    public void onFurnacePlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (!GameWorld.playerIsInGame(player)) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() != Material.FURNACE && block.getType() != Material.BLAST_FURNACE && block.getType() != Material.SMOKER) {
            return;
        }
        Furnace furnace = (Furnace)block.getState();
        furnace.setCookSpeedMultiplier(4.0);
        furnace.update();
    }
}

