/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game.game;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.worlds.game.GameWorld;
import io.github.mal32.endergames.worlds.game.game.AbstractTask;
import io.github.mal32.endergames.worlds.game.game.FightDetection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerSwapManager
extends AbstractTask {
    public PlayerSwapManager(EnderGames plugin) {
        super(plugin);
    }

    @Override
    public int getDelayTicks() {
        int playerCount = GameWorld.getPlayersInGame().length;
        return 3600 / playerCount;
    }

    @Override
    public void task() {
        ArrayList<Player> players = new ArrayList<Player>(Arrays.stream(GameWorld.getPlayersInGame()).toList());
        if (players.size() < 2) {
            return;
        }
        Player player1 = (Player)players.get(new Random().nextInt(players.size()));
        players.remove(player1);
        Player player2 = (Player)players.get(new Random().nextInt(players.size()));
        Location player1Location = player1.getLocation().clone();
        Location player2Location = player2.getLocation().clone();
        player1.teleport(player2Location);
        player2.teleport(player1Location);
        this.playerSwapEffects(player1);
        this.playerSwapEffects(player2);
        this.switchIntoFightProtection(player1, player2);
    }

    private void playerSwapEffects(Player player) {
        Location location = player.getLocation();
        location.getWorld().playSound(location, Sound.ENTITY_PLAYER_TELEPORT, 1.0f, 0.5f);
        location.getWorld().spawnParticle(Particle.PORTAL, location, 50, 0.0, 0.0, 0.0);
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 20, 0, true));
    }

    private void switchIntoFightProtection(Player player1, Player player2) {
        if (FightDetection.playerIsInFight(player1) && !FightDetection.playerIsInFight(player2)) {
            player2.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 40, 4, true, false, true));
        }
        if (FightDetection.playerIsInFight(player2) && !FightDetection.playerIsInFight(player1)) {
            player1.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 40, 4, true, false, true));
        }
    }
}

