/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game.game;

import io.github.mal32.endergames.AbstractModule;
import io.github.mal32.endergames.EnderGames;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectsStacking
extends AbstractModule {
    private static final Comparator<PotionEffect> comparator = Comparator.comparingInt(e -> -e.getAmplifier());
    private static final HashMap<UUID, HashMap<PotionEffectType, PriorityQueue<PotionEffect>>> playerEffects = new HashMap();

    public PotionEffectsStacking(EnderGames plugin) {
        super(plugin);
    }

    public static void addPotionEffect(Player player, PotionEffect newPotionEffect) {
        PotionEffect oldPotionEffect = player.getPotionEffect(newPotionEffect.getType());
        if (oldPotionEffect == null) {
            player.addPotionEffect(newPotionEffect);
            return;
        }
        PotionEffectsStacking.applyEffect(player, newPotionEffect, oldPotionEffect);
    }

    @EventHandler
    private void onPotionEffect(EntityPotionEffectEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getAction() != EntityPotionEffectEvent.Action.CHANGED) {
            return;
        }
        if (event.getCause() == EntityPotionEffectEvent.Cause.PLUGIN) {
            return;
        }
        PotionEffect newPotionEffect = event.getNewEffect();
        if (newPotionEffect == null) {
            return;
        }
        PotionEffect oldPotionEffect = event.getOldEffect();
        if (oldPotionEffect == null) {
            return;
        }
        PotionEffectsStacking.applyEffect(player, newPotionEffect, oldPotionEffect);
    }

    private static void applyEffect(Player player, PotionEffect newPotionEffect, PotionEffect oldPotionEffect) {
        HashMap effectTypes = playerEffects.computeIfAbsent(player.getUniqueId(), k -> new HashMap());
        PriorityQueue effectList = effectTypes.computeIfAbsent(newPotionEffect.getType(), k -> new PriorityQueue<PotionEffect>(comparator));
        if (newPotionEffect.getAmplifier() > oldPotionEffect.getAmplifier()) {
            effectList.add(oldPotionEffect);
            player.addPotionEffect(newPotionEffect);
        } else if (newPotionEffect.getAmplifier() == oldPotionEffect.getAmplifier()) {
            if (newPotionEffect.getDuration() == -1 || oldPotionEffect.getDuration() == -1) {
                player.addPotionEffect(newPotionEffect.withDuration(-1));
            } else {
                int mergedDuration = oldPotionEffect.getDuration() + newPotionEffect.getDuration();
                player.addPotionEffect(oldPotionEffect.withDuration(mergedDuration));
            }
        } else {
            effectList.add(newPotionEffect);
        }
    }

    @EventHandler
    private void onPotionEffectExpiration(EntityPotionEffectEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getCause() != EntityPotionEffectEvent.Cause.EXPIRATION || event.getAction() != EntityPotionEffectEvent.Action.REMOVED) {
            return;
        }
        PotionEffectType oldPotionEffectType = event.getOldEffect().getType();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            HashMap<PotionEffectType, PriorityQueue<PotionEffect>> effectTypes = playerEffects.get(player.getUniqueId());
            if (effectTypes == null) {
                return;
            }
            PriorityQueue<PotionEffect> effectList = effectTypes.get(oldPotionEffectType);
            if (effectList == null || effectList.isEmpty()) {
                return;
            }
            PotionEffect nextStrongestEffect = (PotionEffect)effectList.remove();
            player.addPotionEffect(nextStrongestEffect);
        });
    }
}

