/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game.game;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.worlds.game.GameWorld;
import io.github.mal32.endergames.worlds.game.game.AbstractTeleportingBlockManager;
import io.github.mal32.endergames.worlds.game.game.PotionEffectsStacking;
import io.github.mal32.endergames.worlds.game.game.SpeedObsidian;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SpeedObsidianManager
extends AbstractTeleportingBlockManager<SpeedObsidian> {
    public SpeedObsidianManager(EnderGames plugin, Location spawnLocation) {
        super(plugin, spawnLocation);
    }

    @Override
    public int getBlockTeleportDelayTicks() {
        return 800;
    }

    @Override
    protected int blocksPerPlayer() {
        return 5;
    }

    @Override
    protected SpeedObsidian getNewBlock(Location location) {
        return new SpeedObsidian(this.plugin, location);
    }

    @EventHandler
    public void onPlayerObsidianInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null || event.getClickedBlock().getType() != Material.OBSIDIAN) {
            return;
        }
        Player player = event.getPlayer();
        if (!GameWorld.playerIsInGame(player)) {
            return;
        }
        Block block = event.getClickedBlock();
        SpeedObsidian speedObsidian = (SpeedObsidian)this.getBlockAtLocation(block.getLocation());
        if (speedObsidian == null) {
            return;
        }
        if (player.isInWater()) {
            PotionEffect dolphinGraceEffect = new PotionEffect(PotionEffectType.DOLPHINS_GRACE, 200, 0, false, false, true);
            PotionEffectsStacking.addPotionEffect(player, dolphinGraceEffect);
        } else {
            PotionEffect speedEffect = new PotionEffect(PotionEffectType.SPEED, 400, 1, false, false, true);
            PotionEffectsStacking.addPotionEffect(player, speedEffect);
        }
        speedObsidian.teleport(this.spawnLocation);
    }
}

