/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game.game;

import io.github.mal32.endergames.AbstractModule;
import io.github.mal32.endergames.EnderGames;
import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class SwapperItem
extends AbstractModule {
    private final HashMap<UUID, UUID> thrownSwappers = new HashMap();

    public SwapperItem(EnderGames plugin) {
        super(plugin);
    }

    @EventHandler
    public void onPlayerSnowballThrow(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof Snowball)) {
            return;
        }
        Snowball snowball = (Snowball)projectile;
        ProjectileSource projectileSource = snowball.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        ItemStack item = player.getInventory().getItemInMainHand();
        String itemName = "";
        if (item.getItemMeta().hasItemName()) {
            itemName = ((TextComponent)item.getItemMeta().itemName()).content();
        }
        if (!itemName.equals("Swapper")) {
            return;
        }
        this.thrownSwappers.put(snowball.getUniqueId(), player.getUniqueId());
    }

    @EventHandler
    public void onSnowBallHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof Snowball)) {
            return;
        }
        Snowball snowball = (Snowball)projectile;
        if (!this.thrownSwappers.containsKey(snowball.getUniqueId())) {
            return;
        }
        Entity entity = event.getHitEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity hitEntity = (LivingEntity)entity;
        ProjectileSource projectileSource = snowball.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player shooter = (Player)projectileSource;
        this.thrownSwappers.remove(snowball.getUniqueId());
        this.swap(shooter, hitEntity);
    }

    private void swap(Player player, LivingEntity entity) {
        Location playerLocation = player.getLocation().clone();
        Location entityLocation = entity.getLocation().clone();
        player.teleport(entityLocation);
        entity.teleport(playerLocation);
        this.swapEffects((LivingEntity)player);
        this.swapEffects(entity);
    }

    private void swapEffects(LivingEntity player) {
        Location location = player.getLocation();
        location.getWorld().playSound(location, Sound.ENTITY_PLAYER_TELEPORT, 1.0f, 0.5f);
        location.getWorld().spawnParticle(Particle.PORTAL, location, 50, 0.0, 0.0, 0.0);
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 10, 0, true));
    }
}

