/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.game.game;

import io.github.mal32.endergames.AbstractModule;
import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.worlds.game.GameWorld;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.LodestoneTracker;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class Tracker
extends AbstractModule {
    public Tracker(EnderGames plugin) {
        super(plugin);
    }

    @EventHandler
    private void onTrackerClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!GameWorld.playerIsInGame(player)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.COMPASS) {
            return;
        }
        Player nearestPlayer = this.getNearestValidPlayer(player);
        if (nearestPlayer == null) {
            return;
        }
        Location targetLocation = nearestPlayer.getLocation();
        Location currentLocation = player.getLocation();
        int distance = (int)currentLocation.distance(targetLocation);
        BuildableComponent actionBarMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Tracking ", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)nearestPlayer.getName(), (TextColor)TextColor.fromHexString((String)"#FFBA43")))).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)(distance + " blocks"), (TextColor)NamedTextColor.GREEN))).build();
        player.sendActionBar((Component)actionBarMessage);
        item.setData(DataComponentTypes.LODESTONE_TRACKER, (Object)((LodestoneTracker)LodestoneTracker.lodestoneTracker().tracked(false).location(targetLocation).build()));
    }

    @Nullable
    private Player getNearestValidPlayer(Player executor) {
        Player nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        Location executorLocation = executor.getLocation();
        for (Player other : GameWorld.getPlayersInGame()) {
            double distance;
            if (other.equals((Object)executor) || other.hasPotionEffect(PotionEffectType.INVISIBILITY) || !((distance = executorLocation.distance(other.getLocation())) < nearestDistance)) continue;
            nearestDistance = distance;
            nearest = other;
        }
        return nearest;
    }
}

