/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.lobby;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.worlds.AbstractWorld;
import io.github.mal32.endergames.worlds.lobby.ParkourManager;
import io.github.mal32.endergames.worlds.lobby.items.MenuManager;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;

public class LobbyWorld
extends AbstractWorld {
    private final MenuManager menuManager;
    private final World lobbyWorld = Objects.requireNonNull(Bukkit.getWorld((String)"world_enga_lobby"));
    private final Location spawnLocation = new Location(this.lobbyWorld, 0.0, 64.0, 0.0);
    private final ParkourManager pmanager;

    public LobbyWorld(EnderGames plugin) {
        super(plugin);
        this.pmanager = new ParkourManager(plugin);
        this.menuManager = new MenuManager(this.plugin);
        this.lobbyWorld.setSpawnLocation(this.spawnLocation);
        this.lobbyWorld.setGameRule(GameRule.SPAWN_RADIUS, (Object)6);
        this.lobbyWorld.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
        this.lobbyWorld.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
        this.lobbyWorld.getWorldBorder().setSize(500.0);
        this.lobbyWorld.setGameRule(GameRule.LOCATOR_BAR, (Object)false);
        this.tryUpdatingLobby();
    }

    private void tryUpdatingLobby() {
        NamespacedKey placedLobbyVersionKey = new NamespacedKey((Plugin)this.plugin, "placed_lobby_version");
        boolean currentLobbyVersion = true;
        Integer placedLobbyVersion = (Integer)this.lobbyWorld.getPersistentDataContainer().get(placedLobbyVersionKey, PersistentDataType.INTEGER);
        if (placedLobbyVersion == null || placedLobbyVersion != 1) {
            this.plugin.getComponentLogger().info("Loading lobby, this could take a few seconds ...");
            this.placeLobby();
            this.lobbyWorld.getPersistentDataContainer().set(placedLobbyVersionKey, PersistentDataType.INTEGER, (Object)1);
        }
    }

    private void placeLobby() {
        StructureManager manager = Bukkit.getServer().getStructureManager();
        Structure structure = manager.loadStructure(new NamespacedKey("enga", "lobby"));
        Location location = this.spawnLocation.clone().add(-structure.getSize().getX() / 2.0, 0.0, -structure.getSize().getZ() / 2.0);
        structure.place(location, true, StructureRotation.NONE, Mirror.NONE, 0, 1.0f, new Random());
    }

    @Override
    public void initPlayer(Player player) {
        player.getInventory().clear();
        this.menuManager.initPlayer(player);
        player.setGameMode(GameMode.ADVENTURE);
        player.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, -1, 1, false, false, false));
        player.teleport(this.spawnLocation.clone().add(0.0, 10.0, 0.0));
        NamespacedKey kitKey = new NamespacedKey((Plugin)this.plugin, "kit");
        String currentKit = (String)player.getPersistentDataContainer().get(kitKey, PersistentDataType.STRING);
        if (currentKit == null || currentKit.isEmpty()) {
            player.getPersistentDataContainer().set(kitKey, PersistentDataType.STRING, (Object)"lumberjack");
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!EnderGames.playerIsInLobbyWorld(player)) {
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onFieldTrample(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!EnderGames.playerIsInLobbyWorld(player)) {
            return;
        }
        if (event.getBlock().getType() != Material.FARMLAND) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack item;
        Material type;
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getClickedBlock() != null && (type = event.getClickedBlock().getType()).name().contains("TRAPDOOR")) {
            event.setCancelled(true);
        }
        if (this.pmanager.isResetItem(item = event.getItem())) {
            event.setCancelled(true);
            Player p = event.getPlayer();
            this.pmanager.resetPlayer(p);
        } else if (this.pmanager.isCancelItem(item)) {
            event.setCancelled(true);
            Player p = event.getPlayer();
            this.pmanager.abortParkour(p);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.pmanager.abortParkour(e.getPlayer());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        if (item != null && (this.pmanager.isResetItem(item) || this.pmanager.isCancelItem(item))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        ItemStack item = event.getOldCursor();
        if (item != null && (this.pmanager.isResetItem(item) || this.pmanager.isCancelItem(item))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDrop(PlayerDropItemEvent event) {
        ItemStack item = event.getItemDrop().getItemStack();
        if (this.pmanager.isResetItem(item) || this.pmanager.isCancelItem(item)) {
            event.setCancelled(true);
        }
    }
}

