/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.lobby;

import io.github.mal32.endergames.worlds.lobby.Checkpoint;
import io.github.mal32.endergames.worlds.lobby.ParkourSession;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ParkourManager
implements Listener {
    private final JavaPlugin plugin;
    private final NamespacedKey resetKey;
    private final NamespacedKey cancelKey;
    private final Map<UUID, ParkourSession> sessions = new ConcurrentHashMap<UUID, ParkourSession>();
    private final Map<UUID, ItemStack> savedHotbar = new ConcurrentHashMap<UUID, ItemStack>();
    private final File recordsFile;
    private final YamlConfiguration recordsConfig = new YamlConfiguration();
    private final Map<UUID, Long> bestTimes = new ConcurrentHashMap<UUID, Long>();
    private final World world = Bukkit.getWorld((String)"world_enga_lobby");
    private final Location START_PLATE = new Location(this.world, -3.0, 70.0, 0.0);
    private final Location RESET_LOCATION = new Location(this.world, -3.5, 70.0, 1.5, 180.0f, 14.0f);
    private final Location FINISH_PLATE = new Location(this.world, 17.5, 81.0, -22.5);
    private final List<Checkpoint> CHECKPOINTS = List.of(new Checkpoint(new Location(this.world, -12.5, 81.0, 27.5, -90.0f, 0.0f)), new Checkpoint(new Location(this.world, 21.5, 80.0, 0.5, 180.0f, 0.0f)));
    private static final int RESET_HOTBAR_SLOT = 1;
    private static final int CANCEL_HOTBAR_SLOT = 2;

    public ParkourManager(JavaPlugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
        this.resetKey = new NamespacedKey((Plugin)plugin, "parkour_reset");
        this.cancelKey = new NamespacedKey((Plugin)plugin, "parkour_cancel");
        this.recordsFile = new File(plugin.getDataFolder(), "parkour-records.yml");
        this.loadRecords();
    }

    private void loadRecords() {
        try {
            YamlConfiguration cfg;
            ConfigurationSection section;
            if (!this.recordsFile.exists()) {
                this.plugin.getDataFolder().mkdirs();
                this.recordsFile.createNewFile();
            }
            Set keys = (section = (cfg = YamlConfiguration.loadConfiguration((File)this.recordsFile)).getConfigurationSection("bestTimes")) != null ? section.getKeys(false) : Collections.emptySet();
            for (String k : keys) {
                try {
                    UUID uuid = UUID.fromString(k);
                    long t = cfg.getLong("bestTimes." + k, -1L);
                    if (t < 0L) continue;
                    this.bestTimes.put(uuid, t);
                }
                catch (IllegalArgumentException ex) {
                    this.plugin.getLogger().warning("Invalid UUID in parkour-records.yml: " + k);
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not load parkour-records.yml: " + e.getMessage());
        }
    }

    private void saveRecords() {
        try {
            YamlConfiguration cfg = new YamlConfiguration();
            for (Map.Entry<UUID, Long> ent : this.bestTimes.entrySet()) {
                cfg.set("bestTimes." + ent.getKey().toString(), (Object)ent.getValue());
            }
            cfg.save(this.recordsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save parkour-records.yml: " + e.getMessage());
        }
    }

    @EventHandler
    private void onPressurePlateRedstone(BlockRedstoneEvent event) {
        Material type = event.getBlock().getType();
        if (type != Material.HEAVY_WEIGHTED_PRESSURE_PLATE && type != Material.LIGHT_WEIGHTED_PRESSURE_PLATE) {
            return;
        }
        int oldPower = event.getOldCurrent();
        int newPower = event.getNewCurrent();
        if (oldPower != 0 || newPower <= 0) {
            return;
        }
        for (Player p : event.getBlock().getWorld().getPlayers()) {
            Location plateBlock;
            Location playerBlockLoc = p.getLocation().getBlock().getLocation();
            if (!(playerBlockLoc.distanceSquared(plateBlock = event.getBlock().getLocation()) <= 1.0)) continue;
            this.handlePlateStepped(p, plateBlock, type);
        }
    }

    public boolean isInParkour(Player p) {
        return this.sessions.containsKey(p.getUniqueId());
    }

    public void startParkour(Player p) {
        UUID id = p.getUniqueId();
        long now = System.currentTimeMillis();
        if (this.sessions.containsKey(id)) {
            p.sendMessage(Component.text((String)"Time reset to 0:00").color((TextColor)NamedTextColor.GRAY));
            ParkourSession s = this.sessions.get(id);
            s.reset(now, this.RESET_LOCATION);
            return;
        }
        ParkourSession s = new ParkourSession(now, this.RESET_LOCATION);
        this.sessions.put(id, s);
        ItemStack prev = p.getInventory().getItem(1);
        if (prev != null) {
            this.savedHotbar.put(id, prev);
        }
        p.getInventory().setItem(1, this.createResetItem());
        p.getInventory().setItem(2, this.createCancelItem());
        p.sendActionBar(Component.text((String)"Parkour challenge started!     Good luck!", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        p.sendMessage(Component.text((String)"Parkour started! Use the reset item to go back.").color((TextColor)NamedTextColor.GREEN));
        this.plugin.getLogger().info(p.getName() + " started parkour.");
    }

    public void resetPlayer(Player p) {
        ParkourSession s = this.sessions.get(p.getUniqueId());
        Location respawn = s != null && s.lastCheckpointLocation != null ? s.lastCheckpointLocation.clone() : this.RESET_LOCATION.clone();
        p.teleport(respawn);
        p.sendMessage(Component.text((String)"Reset to last checkpoint.").color((TextColor)NamedTextColor.RED));
    }

    public void checkpointReached(Player p, Location chkLocation) {
        UUID id = p.getUniqueId();
        ParkourSession s = this.sessions.get(id);
        if (s == null) {
            return;
        }
        int index = this.indexOfCheckpoint(chkLocation);
        if (index <= 0) {
            return;
        }
        if (index != s.lastCheckpointIndex + 1) {
            if (index < s.lastCheckpointIndex) {
                p.sendMessage(Component.text((String)"You already have a newer checkpoint. Use the reset item to get there.").color((TextColor)NamedTextColor.GRAY));
            } else if (index > s.lastCheckpointIndex) {
                p.sendMessage(Component.text((String)"You skipped a checkpoint").color((TextColor)NamedTextColor.RED));
                this.abortParkour(p);
            }
            return;
        }
        long now = System.currentTimeMillis();
        long delta = now - s.lastCheckpointTime;
        s.lastCheckpointTime = now;
        s.lastCheckpointIndex = index;
        Checkpoint cp = this.CHECKPOINTS.get(index - 1);
        s.lastCheckpointLocation = cp.getRespawn().clone();
        p.sendMessage(Component.text((String)("Finished part " + index + " in " + ParkourManager.formatTime(delta))).color((TextColor)NamedTextColor.AQUA));
    }

    private int indexOfCheckpoint(Location l) {
        for (int i = 0; i < this.CHECKPOINTS.size(); ++i) {
            if (!this.isSameBlock(this.CHECKPOINTS.get(i).getPlate(), l)) continue;
            return i + 1;
        }
        return -1;
    }

    public void finishParkour(Player p) {
        UUID id = p.getUniqueId();
        ParkourSession s = this.sessions.remove(id);
        if (s == null) {
            return;
        }
        long now = System.currentTimeMillis();
        long elapsed = now - s.startTime;
        String formatted = ParkourManager.formatTime(elapsed);
        p.showTitle(Title.title((Component)Component.text((String)"Parkour finished", (TextColor)NamedTextColor.GOLD), (Component)Component.text((String)"", (TextColor)NamedTextColor.GRAY)));
        p.sendMessage(Component.text((String)("You finished in " + formatted)).color((TextColor)NamedTextColor.GOLD));
        p.playSound(p.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
        Long best = this.bestTimes.get(id);
        if (best == null || elapsed < best) {
            this.bestTimes.put(id, elapsed);
            this.saveRecords();
            p.sendMessage(Component.text((String)"New best time!").color((TextColor)NamedTextColor.GREEN));
        } else {
            p.sendMessage(Component.text((String)("Best: " + ParkourManager.formatTime(best))).color((TextColor)NamedTextColor.GRAY));
        }
        this.restoreHotbar(id, p);
        this.plugin.getLogger().info(p.getName() + " finished parkour in " + elapsed + "ms");
    }

    public void abortParkour(Player p) {
        UUID id = p.getUniqueId();
        if (this.sessions.remove(id) != null) {
            this.restoreHotbar(id, p);
            p.sendMessage(Component.text((String)"Parkour aborted.").color((TextColor)NamedTextColor.RED));
        }
    }

    private void restoreHotbar(UUID id, Player p) {
        ItemStack prev = this.savedHotbar.remove(id);
        try {
            p.getInventory().setItem(1, prev);
            p.getInventory().setItem(2, null);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to restore hotbar for " + String.valueOf(id));
        }
    }

    public ItemStack createResetItem() {
        ItemStack item = new ItemStack(Material.RED_DYE);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)"Reset", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false));
        meta.getPersistentDataContainer().set(this.resetKey, PersistentDataType.BYTE, (Object)1);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack createCancelItem() {
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)"Cancel Parkour", (TextColor)NamedTextColor.RED).decoration(TextDecoration.ITALIC, false));
        meta.getPersistentDataContainer().set(this.cancelKey, PersistentDataType.BYTE, (Object)1);
        item.setItemMeta(meta);
        return item;
    }

    public boolean isResetItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!stack.hasItemMeta()) {
            return false;
        }
        Byte has = (Byte)stack.getItemMeta().getPersistentDataContainer().get(this.resetKey, PersistentDataType.BYTE);
        return has != null && has == 1;
    }

    public boolean isCancelItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!stack.hasItemMeta()) {
            return false;
        }
        Byte has = (Byte)stack.getItemMeta().getPersistentDataContainer().get(this.cancelKey, PersistentDataType.BYTE);
        return has != null && has == 1;
    }

    public void handlePlateStepped(Player p, Location plateBlockLocation, Material plateType) {
        int idx;
        if (this.isSameBlock(plateBlockLocation, this.START_PLATE) && plateType == Material.HEAVY_WEIGHTED_PRESSURE_PLATE) {
            this.startParkour(p);
            return;
        }
        if (this.isSameBlock(plateBlockLocation, this.FINISH_PLATE) && plateType == Material.LIGHT_WEIGHTED_PRESSURE_PLATE) {
            ParkourSession s = this.sessions.get(p.getUniqueId());
            if (s == null) {
                p.sendMessage(Component.text((String)"You are not currently running the parkour.").color((TextColor)NamedTextColor.GRAY));
                return;
            }
            if (!this.CHECKPOINTS.isEmpty() && s.lastCheckpointIndex != this.CHECKPOINTS.size()) {
                p.sendMessage(Component.text((String)"You didn't hit all checkpoints").color((TextColor)NamedTextColor.RED));
                p.sendMessage(Component.text((String)("Last checkpoint reached: " + s.lastCheckpointIndex + " / " + this.CHECKPOINTS.size())).color((TextColor)NamedTextColor.GRAY));
                this.abortParkour(p);
                return;
            }
            this.finishParkour(p);
            return;
        }
        if (this.isInParkour(p) && plateType == Material.HEAVY_WEIGHTED_PRESSURE_PLATE && (idx = this.indexOfCheckpoint(plateBlockLocation)) > 0) {
            this.checkpointReached(p, plateBlockLocation);
        }
    }

    private boolean isSameBlock(Location a, Location b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getWorld() == null || b.getWorld() == null) {
            return false;
        }
        if (!a.getWorld().getName().equals(b.getWorld().getName())) {
            return false;
        }
        return a.distanceSquared(b) < 3.0;
    }

    private static String formatTime(long ms) {
        long minutes = ms / 1000L / 60L;
        long seconds = ms / 1000L % 60L;
        long millis = ms % 1000L;
        return String.format("%d:%02d.%03d", minutes, seconds, millis);
    }

    public void shutdown() {
        for (UUID id : new ArrayList<UUID>(this.sessions.keySet())) {
            Player p = Bukkit.getPlayer((UUID)id);
            if (p == null || !p.isOnline()) continue;
            this.restoreHotbar(id, p);
        }
        this.sessions.clear();
        this.saveRecords();
    }
}

