/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.lobby.items;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.kits.KitDescription;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

class KitInventory
implements InventoryHolder {
    private final List<AbstractKit> availableKits;
    private final Inventory inventory;
    public String selectedKitName;

    public KitInventory(EnderGames plugin, List<AbstractKit> availableKits, String selectedKitName) {
        this.availableKits = availableKits;
        this.selectedKitName = selectedKitName;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 27, (Component)Component.text((String)"Select Kit"));
        this.updateKitItems();
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void updateKitItems() {
        this.inventory.clear();
        for (AbstractKit kit : this.availableKits) {
            KitDescription kitDescription = kit.getDescription();
            ItemStack kitItem = new ItemStack(kitDescription.item(), 1);
            ItemMeta meta = kitItem.getItemMeta();
            meta.displayName(((TextComponent)Component.text((String)kitDescription.name()).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false));
            meta.lore(this.getKitLore(kitDescription));
            kitItem.setItemMeta(meta);
            if (kit.getNameLowercase().equals(this.selectedKitName)) {
                ItemMeta clickedMeta = kitItem.getItemMeta();
                clickedMeta.addEnchant(Enchantment.INFINITY, 1, true);
                clickedMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                kitItem.setItemMeta(clickedMeta);
            }
            this.inventory.addItem(new ItemStack[]{kitItem});
        }
    }

    private List<TextComponent> getKitLore(KitDescription kitDescription) {
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        TextComponent abilitiesHeaderComponent = (TextComponent)((TextComponent)Component.text((String)"Abilities:").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false);
        lore.add(abilitiesHeaderComponent);
        ArrayList<String> abilitiesText = KitInventory.splitIntoLines(kitDescription.abilities());
        lore.addAll(KitInventory.convertTextListToComponents(abilitiesText));
        lore.add(Component.text((String)""));
        if (kitDescription.equipment() != null) {
            TextComponent equipmentHeaderComponent = (TextComponent)((TextComponent)Component.text((String)"Equipment:").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false);
            lore.add(equipmentHeaderComponent);
            ArrayList<String> equipmentText = KitInventory.splitIntoLines(kitDescription.equipment());
            lore.addAll(KitInventory.convertTextListToComponents(equipmentText));
            lore.add(Component.text((String)""));
        }
        lore.add((TextComponent)((TextComponent)Component.text((String)"Difficulty:").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        switch (kitDescription.difficulty()) {
            case EASY: {
                lore.add((TextComponent)((TextComponent)Component.text((String)"\u2588\u2592\u2592 Easy").color((TextColor)NamedTextColor.GREEN)).decoration(TextDecoration.ITALIC, false));
                break;
            }
            case MEDIUM: {
                lore.add((TextComponent)((TextComponent)Component.text((String)"\u2588\u2588\u2592 Medium").color((TextColor)NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false));
                break;
            }
            case HARD: {
                lore.add((TextComponent)((TextComponent)Component.text((String)"\u2588\u2588\u2588 Hard").color((TextColor)NamedTextColor.RED)).decoration(TextDecoration.ITALIC, false));
            }
        }
        return lore;
    }

    private static ArrayList<String> splitIntoLines(String text) {
        ArrayList<String> lines = new ArrayList<String>();
        int maxLineLength = 20;
        int charactersInLine = 0;
        int lineStartIndex = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (++charactersInLine <= 20 || text.charAt(i) != ' ') continue;
            String line = text.substring(lineStartIndex, i);
            lines.add(line);
            charactersInLine = 0;
            lineStartIndex = i + 1;
        }
        lines.add(text.substring(lineStartIndex));
        return lines;
    }

    private static List<TextComponent> convertTextListToComponents(ArrayList<String> lines) {
        return lines.stream().map(line -> (TextComponent)((TextComponent)Component.text((String)line).color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false)).toList();
    }
}

