/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.lobby.items;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.kits.AbstractKit;
import io.github.mal32.endergames.worlds.lobby.items.KitInventory;
import io.github.mal32.endergames.worlds.lobby.items.MenuItem;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

class KitSelector
extends MenuItem
implements Listener {
    private final NamespacedKey kitStorageKey;
    private final List<AbstractKit> availableKits;

    public KitSelector(EnderGames plugin) {
        super(plugin, Material.CHEST, Component.text((String)"Select Kit").color((TextColor)NamedTextColor.GOLD), "kit_selector", (byte)0);
        this.kitStorageKey = new NamespacedKey((Plugin)plugin, "kit");
        this.availableKits = AbstractKit.getKits(plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void initPlayer(Player player) {
        this.giveItem(player);
    }

    @Override
    public void playerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        player.playSound((Entity)player, Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
        String selectedKit = (String)player.getPersistentDataContainer().get(this.kitStorageKey, PersistentDataType.STRING);
        KitInventory kiInv = new KitInventory(this.plugin, this.availableKits, selectedKit);
        player.openInventory(kiInv.getInventory());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory clickedInv = event.getClickedInventory();
        if (clickedInv == null || !(clickedInv.getHolder() instanceof KitInventory)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta() || !clickedItem.getItemMeta().hasDisplayName()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Component displayName = clickedItem.getItemMeta().displayName();
        if (displayName == null) {
            return;
        }
        String nameText = LegacyComponentSerializer.legacySection().serialize(displayName);
        String kitName = nameText.length() > 2 ? nameText.substring(2).toLowerCase() : "";
        AbstractKit kit = this.availableKits.stream().filter(k -> k.getNameLowercase().equalsIgnoreCase(kitName)).findFirst().orElse(null);
        if (kit == null) {
            this.plugin.getComponentLogger().warn("Invalid kit selected: {}", (Object)kitName);
            return;
        }
        player.getPersistentDataContainer().set(this.kitStorageKey, PersistentDataType.STRING, (Object)kitName);
        player.sendMessage(((TextComponent)Component.text((String)"You selected the ").append(Component.text((String)StringUtils.capitalize((String)kitName)).color((TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)" kit")));
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_HAT, 1.0f, 1.0f);
        KitInventory kitInv = (KitInventory)event.getInventory().getHolder();
        kitInv.selectedKitName = kitName;
        kitInv.updateKitItems();
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getInventory().getHolder() instanceof KitInventory)) {
            return;
        }
        event.setCancelled(true);
    }
}

