/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.lobby.items;

import io.github.mal32.endergames.AbstractModule;
import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.worlds.lobby.items.KitSelector;
import io.github.mal32.endergames.worlds.lobby.items.MenuItem;
import io.github.mal32.endergames.worlds.lobby.items.OperatorStartItem;
import java.util.HashMap;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MenuManager
extends AbstractModule {
    private final HashMap<String, MenuItem> items = new HashMap();
    private final NamespacedKey menuKey;

    public MenuManager(EnderGames plugin) {
        super(plugin);
        this.enable();
        List<OperatorStartItem> rawItems = List.of(new KitSelector(plugin), new OperatorStartItem(plugin));
        for (MenuItem menuItem : rawItems) {
            this.items.put(menuItem.getKey(), menuItem);
        }
        this.menuKey = new NamespacedKey((Plugin)plugin, "menu");
    }

    public void initPlayer(Player player) {
        for (MenuItem item : this.items.values()) {
            item.initPlayer(player);
        }
    }

    private boolean isMenuItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        return item.getPersistentDataContainer().has(this.menuKey, PersistentDataType.STRING);
    }

    @EventHandler
    private void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!EnderGames.playerIsInLobbyWorld(player)) {
            return;
        }
        ItemStack item = event.getItem();
        if (!this.isMenuItem(item)) {
            return;
        }
        String itemKey = (String)item.getPersistentDataContainer().get(this.menuKey, PersistentDataType.STRING);
        this.items.get(itemKey).playerInteract(event);
        event.setCancelled(true);
    }

    @EventHandler
    private void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!EnderGames.playerIsInLobbyWorld(player)) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (!this.isMenuItem(item)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    private void onPlayerDropItem(PlayerDropItemEvent event) {
        if (!EnderGames.playerIsInLobbyWorld(event.getPlayer())) {
            return;
        }
        ItemStack item = event.getItemDrop().getItemStack();
        if (!this.isMenuItem(item)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        if (!EnderGames.playerIsInLobbyWorld(event.getPlayer())) {
            return;
        }
        ItemStack item = event.getOffHandItem();
        if (!this.isMenuItem(item)) {
            return;
        }
        event.setCancelled(true);
    }
}

