/*
 * Decompiled with CFR 0.152.
 */
package io.github.mal32.endergames.worlds.lobby.items;

import io.github.mal32.endergames.EnderGames;
import io.github.mal32.endergames.worlds.lobby.items.CancelStartItem;
import io.github.mal32.endergames.worlds.lobby.items.MenuItem;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

class OperatorStartItem
extends MenuItem {
    private final MenuItem cancelItem = new CancelStartItem(this.plugin);
    private BukkitTask startGameTask = null;

    public OperatorStartItem(EnderGames plugin) {
        super(plugin, Material.NETHER_STAR, Component.text((String)"Start Game").color((TextColor)NamedTextColor.GOLD), "start_game", (byte)8);
    }

    @Override
    public void initPlayer(Player player) {
        if (!player.isOp()) {
            return;
        }
        this.giveItem(player);
    }

    @Override
    public void playerInteract(PlayerInteractEvent event) {
        event.getPlayer().playSound(event.getPlayer().getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        if (this.startGameTask == null) {
            this.scheduleGameStart();
        } else {
            this.stopGameStart();
        }
    }

    private void scheduleGameStart() {
        int startDelaySeconds = EnderGames.isInDebugMode() ? 10 : 5;
        this.startGameTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.plugin.getGameWorld().startGame();
            this.startGameTask = null;
        }, (long)(startDelaySeconds * 20));
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.isOp()) continue;
            player.sendActionBar(Component.text((String)"The game will start in 5 seconds!").color((TextColor)NamedTextColor.GREEN));
            this.cancelItem.giveItem(player);
        }
    }

    private void stopGameStart() {
        this.startGameTask.cancel();
        this.startGameTask = null;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.isOp()) continue;
            player.sendActionBar(Component.text((String)"Start was canceled!").color((TextColor)NamedTextColor.RED));
            this.giveItem(player);
        }
    }
}

