/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.culling;

import de.pianoman911.playerculling.core.culling.CullPlayer;
import de.pianoman911.playerculling.core.culling.CullShip;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CullContainer
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CullContainer");
    private final CullShip ship;
    private final Set<CullPlayer> players = Collections.newSetFromMap(new WeakHashMap());
    private final int containerId;
    private final long[] times = new long[10];
    private long lastPanic = 0L;
    private long lastSinceEmpty = Long.MAX_VALUE;
    private int index = 0;
    private ParkReason parkReason = ParkReason.NO_PLAYERS;
    private boolean culling = true;

    public CullContainer(int containerId, CullShip ship) {
        super("PlayerCulling-CullContainer-" + containerId);
        this.containerId = containerId;
        this.ship = ship;
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Thread.interrupted()) {
            this.lastSinceEmpty = System.currentTimeMillis();
            try {
                List<CullPlayer> players;
                if (!this.culling) {
                    this.parkReason = ParkReason.CULLING_DISABLED;
                    Arrays.fill(this.times, 0L);
                    LockSupport.park();
                    continue;
                }
                long start = System.nanoTime();
                Set<CullPlayer> set = this.players;
                synchronized (set) {
                    players = List.copyOf(this.players);
                }
                if (players.isEmpty()) {
                    Arrays.fill(this.times, 0L);
                    this.parkReason = ParkReason.NO_PLAYERS;
                    LockSupport.park();
                    continue;
                }
                boolean forcePanic = this.cull(players, start);
                long end = System.nanoTime();
                long time = end - start;
                this.times[this.index++] = time;
                if (this.index == this.times.length) {
                    this.index = 0;
                }
                if (time > this.ship.getConfig().getDelegate().scheduler.getMaxCullTimeNs() || forcePanic) {
                    this.panic();
                }
                this.parkReason = ParkReason.TIME_LEFT;
                LockSupport.parkNanos(this.ship.getConfig().getDelegate().scheduler.getMaxCullTimeNs() - time);
            }
            catch (Throwable throwable) {
                LOGGER.error("Error in culling container", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cull(List<CullPlayer> players, long startTime) {
        for (CullPlayer player : players) {
            if (System.nanoTime() - startTime > this.ship.getConfig().getDelegate().scheduler.getMaxCullTimeNs()) {
                this.transferPlayer(player);
                return true;
            }
            if (player.getPlatformPlayer().isOnline()) {
                player.cull();
                continue;
            }
            Set<CullPlayer> set = this.players;
            synchronized (set) {
                this.players.remove(player);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void panic() {
        boolean removed;
        CullPlayer first;
        if (this.players.size() < 2 && this.lastPanic + 10000L > System.currentTimeMillis()) {
            LOGGER.warn("Culling is to slow! Extreme panic, only 1 player is in the container, transferring is not worth...");
            this.lastPanic = System.currentTimeMillis();
            return;
        }
        Set<CullPlayer> set = this.players;
        synchronized (set) {
            first = this.players.iterator().next();
            removed = this.players.remove(first);
        }
        if (removed) {
            this.ship.addPlayer(first);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferPlayer(CullPlayer player) {
        Set<CullPlayer> set = this.players;
        synchronized (set) {
            this.players.remove(player);
        }
        this.ship.addPlayer(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeInto(CullContainer other) {
        Set<CullPlayer> set = this.players;
        synchronized (set) {
            for (CullPlayer player : this.players) {
                if (other == this) continue;
                other.addPlayer0(player);
            }
            this.players.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(CullPlayer player) {
        Set<CullPlayer> set = this.players;
        synchronized (set) {
            this.addPlayer0(player);
        }
    }

    private void addPlayer0(CullPlayer player) {
        this.players.add(player);
        if (this.parkReason == ParkReason.NO_PLAYERS) {
            LockSupport.unpark(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleCulling(boolean enabled) {
        Set<CullPlayer> players;
        this.culling = enabled;
        if (enabled) {
            if (this.parkReason != ParkReason.NO_PLAYERS) {
                this.parkReason = ParkReason.TIME_LEFT;
                LockSupport.unpark(this);
            }
            return;
        }
        Set<CullPlayer> set = this.players;
        synchronized (set) {
            players = Set.copyOf(this.players);
        }
        for (CullPlayer player : players) {
            player.resetHidden();
        }
    }

    public long getAverageCullTime() {
        long sum = 0L;
        for (long time : this.times) {
            sum += time;
        }
        return sum / (long)this.times.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerCount() {
        Set<CullPlayer> set = this.players;
        synchronized (set) {
            return this.players.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastRayStepCount() {
        long sum = 0L;
        Set<CullPlayer> set = this.players;
        synchronized (set) {
            for (CullPlayer player : this.players) {
                sum += player.getLastRaySteps();
            }
        }
        return sum;
    }

    public ParkReason getParkReason() {
        return this.parkReason;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public long getTtl() {
        return this.lastSinceEmpty + this.ship.getConfig().getDelegate().scheduler.getContainerTtlMs() - System.currentTimeMillis();
    }

    public boolean isEmptyParked() {
        return this.parkReason == ParkReason.NO_PLAYERS && this.getPlayerCount() == 0;
    }

    public static enum ParkReason {
        TIME_LEFT,
        NO_PLAYERS,
        CULLING_DISABLED;

    }
}

