/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.culling;

import de.pianoman911.playerculling.core.occlusion.OcclusionCullingInstance;
import de.pianoman911.playerculling.core.provider.ChunkOcclusionDataProvider;
import de.pianoman911.playerculling.core.util.CameraMode;
import de.pianoman911.playerculling.core.util.ClientsideUtil;
import de.pianoman911.playerculling.platformcommon.AABB;
import de.pianoman911.playerculling.platformcommon.cache.DataProvider;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformPlayer;
import de.pianoman911.playerculling.platformcommon.platform.world.PlatformWorld;
import de.pianoman911.playerculling.platformcommon.util.FastStack;
import de.pianoman911.playerculling.platformcommon.vector.Vec3d;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Unmodifiable;

public final class CullPlayer {
    public static final double AABB_EXPANSION = 0.5;
    private static final double MAX_ANGLE = Math.toRadians(90.0);
    private static final double BLINDNESS_DISTANCE_SQUARED = 36.0;
    private static final double DARKNESS_DISTANCE_SQUARED = 256.0;
    private static final long DARKNESS_MIN_MS = 2000L;
    private static final long BLINDNESS_FADE_OUT_TICKS = 25L;
    private static final long DARKNESS_FADE_OUT_TICKS = 30L;
    private final PlatformPlayer player;
    private final OcclusionCullingInstance cullingInstance;
    private final DataProvider provider = new ChunkOcclusionDataProvider(this);
    private final FastStack<PlatformPlayer> tracked;
    private final Vec3d viewerPosition = new Vec3d(0.0, 0.0, 0.0);
    private final Vec3d viewerDirection = new Vec3d(0.0, 0.0, 0.0);
    private final Vec3d viewerBack = new Vec3d(0.0, 0.0, 0.0);
    private final Vec3d viewerFront = new Vec3d(0.0, 0.0, 0.0);
    private final Set<UUID> hidden = ConcurrentHashMap.newKeySet();
    private final Set<UUID> toRemove = new HashSet<UUID>();
    private boolean cullingEnabled = true;
    private boolean spectating = false;
    private long lastDarkness = -1L;
    private long lastRaySteps = 0L;

    public CullPlayer(PlatformPlayer player) {
        this.player = player;
        this.cullingInstance = new OcclusionCullingInstance(this.provider, 0.5);
        this.provider.world(player.getWorld());
        this.tracked = new FastStack(player.getWorld().getPlayerCount());
    }

    public static boolean isInnerAngle(Vec3d targetPos, Vec3d selfPos, Vec3d dir) {
        return CullPlayer.isInnerAngle(targetPos.x, targetPos.y, targetPos.z, selfPos.x, selfPos.y, selfPos.z, dir.x, dir.y, dir.z);
    }

    public static boolean isInnerAngle(double targetX, double targetY, double targetZ, double selfX, double selfY, double selfZ, double dirX, double dirY, double dirZ) {
        return CullPlayer.angle(targetX, targetY, targetZ, selfX, selfY, selfZ, dirX, dirY, dirZ) <= MAX_ANGLE;
    }

    public static double angle(Vec3d targetPos, Vec3d selfPos, Vec3d dir) {
        return CullPlayer.angle(targetPos.x, targetPos.y, targetPos.z, selfPos.x, selfPos.y, selfPos.z, dir.x, dir.y, dir.z);
    }

    public static double angle(double targetX, double targetY, double targetZ, double selfX, double selfY, double selfZ, double dirX, double dirY, double dirZ) {
        double targetVecX = targetX - selfX;
        double targetVecY = targetY - selfY;
        double targetVecZ = targetZ - selfZ;
        double targetVecDotDir = targetVecX * dirX + targetVecY * dirY + targetVecZ * dirZ;
        double targetVecLengthSqrt = targetVecX * targetVecX + targetVecY * targetVecY + targetVecZ * targetVecZ;
        return Math.acos(targetVecDotDir / Math.sqrt(targetVecLengthSqrt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cull() {
        Object object = this;
        synchronized (object) {
            this.cull0();
            this.lastRaySteps = this.cullingInstance.getAndResetRaySteps();
        }
        object = this.toRemove;
        synchronized (object) {
            this.hidden.removeAll(this.toRemove);
            this.toRemove.clear();
        }
    }

    private void cull0() {
        boolean darkness;
        if (!this.cullingEnabled || this.player.shouldPreventCulling() || this.player.isSpectator() || this.spectating || this.player.hasPermission("playerculling.bypass", false)) {
            this.hidden.clear();
            return;
        }
        PlatformWorld world = this.player.getWorld();
        List<PlatformPlayer> playersInWorld = world.getPlayers();
        if (playersInWorld.size() <= 1) {
            return;
        }
        this.provider.world(world);
        Vec3d eye = this.player.getEyePosition();
        boolean blindness = this.player.getBlindnessTicks() != -1L ? this.player.getBlindnessTicks() > 25L : false;
        if (this.player.getDarknessTicks() != -1L) {
            if (this.lastDarkness == -1L) {
                this.lastDarkness = System.currentTimeMillis();
            }
            darkness = System.currentTimeMillis() - this.lastDarkness > 2000L && this.player.getDarknessTicks() > 30L;
        } else {
            this.lastDarkness = -1L;
            darkness = false;
        }
        int trackingDist = this.provider.getPlayerViewDistance();
        if (trackingDist <= 0) {
            this.hidden.clear();
            return;
        }
        this.tracked.grow(playersInWorld.size());
        double trackingDistSq = trackingDist * trackingDist;
        for (PlatformPlayer worldPlayer : playersInWorld) {
            if (worldPlayer == this.player) continue;
            boolean nameTag = this.player.canSeeNameTag(worldPlayer);
            double distSq = eye.distanceSquared(worldPlayer.getPosition());
            if (worldPlayer.isGlowing() || !worldPlayer.isSneaking() && nameTag) {
                this.unHideWithDirectPairing(worldPlayer);
                continue;
            }
            if (!(!(distSq < trackingDistSq) || blindness && !(distSq < 36.0) || darkness && !(distSq < 256.0))) {
                this.tracked.push(worldPlayer);
                continue;
            }
            this.hidden.add(worldPlayer.getUniqueId());
        }
        if (this.tracked.isEmpty()) {
            return;
        }
        this.viewerPosition.set(eye.getX(), eye.getY(), eye.getZ()).mul(2.0);
        this.viewerDirection.set(this.player.getDirection());
        double inverseViewerDirX = -this.viewerDirection.x;
        double inverseViewerDirY = -this.viewerDirection.y;
        double inverseViewerDirZ = -this.viewerDirection.z;
        boolean backPos = false;
        boolean frontPos = false;
        while (this.tracked.hasEntries()) {
            boolean canSee;
            double aabbMaxZ;
            double aabbCenterZ;
            double aabbMaxY;
            double aabbCenterY;
            PlatformPlayer target = this.tracked.pop();
            if (target == null) continue;
            AABB trackedBox = target.getBoundingBox();
            double aabbMinX = trackedBox.minX() * 2.0;
            double aabbMinY = trackedBox.minY() * 2.0;
            double aabbMinZ = trackedBox.minZ() * 2.0;
            double aabbMaxX = trackedBox.maxX() * 2.0;
            double aabbCenterX = aabbMinX + (aabbMaxX - aabbMinX) / 2.0;
            boolean mainInner = CullPlayer.isInnerAngle(aabbCenterX, aabbCenterY = aabbMinY + ((aabbMaxY = trackedBox.maxY() * 2.0) - aabbMinY) / 2.0, aabbCenterZ = aabbMinZ + ((aabbMaxZ = trackedBox.maxZ() * 2.0) - aabbMinZ) / 2.0, this.viewerPosition.x, this.viewerPosition.y, this.viewerPosition.z, this.viewerDirection.x, this.viewerDirection.y, this.viewerDirection.z);
            boolean bl = canSee = mainInner && this.cullingInstance.isAABBVisible(aabbMinX, aabbMinY, aabbMinZ, aabbMaxX, aabbMaxY, aabbMaxZ, this.viewerPosition);
            if (!canSee) {
                boolean secondaryInner;
                if (!backPos) {
                    this.viewerBack.set(eye.getX(), eye.getY(), eye.getZ());
                    ClientsideUtil.addPlayerViewOffset(this.viewerBack, this.player, CameraMode.THIRD_PERSON_BACK);
                    this.viewerBack.mul(2.0);
                    backPos = true;
                }
                boolean bl2 = canSee = (secondaryInner = CullPlayer.isInnerAngle(aabbCenterX, aabbCenterY, aabbCenterZ, this.viewerBack.x, this.viewerBack.y, this.viewerBack.z, this.viewerDirection.x, this.viewerDirection.y, this.viewerDirection.z)) && this.cullingInstance.isAABBVisible(aabbMinX, aabbMinY, aabbMinZ, aabbMaxX, aabbMaxY, aabbMaxZ, this.viewerBack);
                if (!canSee) {
                    boolean tertiaryInner;
                    if (!frontPos) {
                        this.viewerFront.set(eye.getX(), eye.getY(), eye.getZ());
                        ClientsideUtil.addPlayerViewOffset(this.viewerFront, this.player, CameraMode.THIRD_PERSON_FRONT);
                        this.viewerFront.mul(2.0);
                        frontPos = true;
                    }
                    boolean bl3 = canSee = (tertiaryInner = CullPlayer.isInnerAngle(aabbCenterX, aabbCenterY, aabbCenterZ, this.viewerFront.x, this.viewerFront.y, this.viewerFront.z, inverseViewerDirX, inverseViewerDirY, inverseViewerDirZ)) && this.cullingInstance.isAABBVisible(aabbMinX, aabbMinY, aabbMinZ, aabbMaxX, aabbMaxY, aabbMaxZ, this.viewerFront);
                }
            }
            if (canSee) {
                this.unHideWithDirectPairing(target);
                continue;
            }
            this.hidden.add(target.getUniqueId());
        }
    }

    private void unHideWithDirectPairing(PlatformPlayer target) {
        if (this.hidden.remove(target.getUniqueId())) {
            this.player.addDirectPairing(target);
        }
    }

    public long getLastRaySteps() {
        return this.lastRaySteps;
    }

    public PlatformPlayer getPlatformPlayer() {
        return this.player;
    }

    public boolean isCullingEnabled() {
        return this.cullingEnabled;
    }

    public void setCullingEnabled(boolean cullingEnabled) {
        this.cullingEnabled = cullingEnabled;
        this.resetHidden();
    }

    public boolean isHidden(UUID playerId) {
        return this.hidden.contains(playerId);
    }

    public int getHiddenCount() {
        return this.hidden.size();
    }

    public @Unmodifiable Set<UUID> getHidden() {
        return Set.copyOf(this.hidden);
    }

    public void resetHidden() {
        this.hidden.clear();
    }

    public DataProvider getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateOther(UUID playerId) {
        Set<UUID> set = this.toRemove;
        synchronized (set) {
            this.toRemove.add(playerId);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CullPlayer)) {
            return false;
        }
        CullPlayer other = (CullPlayer)obj;
        return Objects.equals(this.player, other.player);
    }

    public int hashCode() {
        return Objects.hash(this.player);
    }

    public void setSpectating(boolean spectating) {
        this.spectating = spectating;
    }
}

