/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.culling;

import de.pianoman911.playerculling.core.api.PlayerCullingApiImpl;
import de.pianoman911.playerculling.core.culling.CullContainer;
import de.pianoman911.playerculling.core.culling.CullPlayer;
import de.pianoman911.playerculling.core.updater.PlayerCullingUpdater;
import de.pianoman911.playerculling.platformcommon.config.PlayerCullingConfig;
import de.pianoman911.playerculling.platformcommon.config.YamlConfigHolder;
import de.pianoman911.playerculling.platformcommon.platform.IPlatform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CullShip {
    private static final long PANIC_LOG_INTERVAL = 10000L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CullShip");
    private final IPlatform platform;
    private final YamlConfigHolder<PlayerCullingConfig> config;
    private final List<CullContainer> containers;
    private final Map<UUID, CullPlayer> players = new HashMap<UUID, CullPlayer>();
    private final PlayerCullingUpdater updater;
    private int lastContainer = 1;
    private long lastPanicLog = 0L;
    private boolean culling = true;

    public CullShip(IPlatform platform) {
        this.platform = platform;
        this.config = platform.loadConfig();
        this.updater = new PlayerCullingUpdater(this);
        this.containers = new ArrayList<CullContainer>(this.config.getDelegate().scheduler.maxThreads);
        this.containers.add(new CullContainer(this.lastContainer++, this));
        platform.registerApi(new PlayerCullingApiImpl(this));
    }

    public void enable() {
        this.config.addReloadHookAndRun(new Consumer<PlayerCullingConfig>(){
            private int taskId = -1;

            @Override
            public void accept(PlayerCullingConfig config) {
                CullShip.this.platform.cancelTask(this.taskId);
                this.taskId = CullShip.this.platform.runTaskRepeatingAsync(() -> CullShip.this.cleanContainers(false), 0L, config.scheduler.getCleanupIntervalMs());
            }
        });
        this.updater.enable();
    }

    private CullContainer createContainer() {
        CullContainer container = new CullContainer(this.lastContainer++, this);
        this.containers.add(container);
        LOGGER.info("Added new container: {}", (Object)container.getName());
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CullContainer getLowestLoadedContainer() {
        CullContainer lowest;
        CullContainer lowestParked = null;
        List<CullContainer> list = this.containers;
        synchronized (list) {
            if (this.containers.isEmpty()) {
                return this.createContainer();
            }
            lowest = this.containers.getFirst();
            for (CullContainer container : this.containers) {
                if (container.getAverageCullTime() >= lowest.getAverageCullTime()) continue;
                if (container.isEmptyParked()) {
                    lowestParked = container;
                    continue;
                }
                lowest = container;
            }
            if ((double)lowest.getAverageCullTime() > this.config.getDelegate().scheduler.getMaxTransferNs()) {
                if (lowestParked == null) {
                    if (this.containers.size() < this.config.getDelegate().scheduler.maxThreads) {
                        lowest = this.createContainer();
                    } else if (this.lastPanicLog + 10000L < System.currentTimeMillis()) {
                        LOGGER.warn("All containers are overloaded, thread limit reached. Culling skip will be caused.");
                        this.lastPanicLog = System.currentTimeMillis();
                    }
                } else {
                    lowest = lowestParked;
                }
            }
        }
        return lowest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Unmodifiable List<CullContainer> getContainers() {
        List<CullContainer> list = this.containers;
        synchronized (list) {
            return List.copyOf(this.containers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CullPlayer> getPlayers() {
        Map<UUID, CullPlayer> map = this.players;
        synchronized (map) {
            return Set.copyOf(this.players.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CullPlayer getPlayer(UUID playerId) {
        Map<UUID, CullPlayer> map = this.players;
        synchronized (map) {
            return this.players.get(playerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(CullPlayer player) {
        if (!player.getPlatformPlayer().isOnline()) {
            return;
        }
        Map<UUID, CullPlayer> map = this.players;
        synchronized (map) {
            this.players.put(player.getPlatformPlayer().getUniqueId(), player);
        }
        CullContainer container = this.getLowestLoadedContainer();
        container.addPlayer(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(UUID uniqueId) {
        Map<UUID, CullPlayer> map = this.players;
        synchronized (map) {
            this.players.remove(uniqueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLongestCullTime() {
        List<CullContainer> list = this.containers;
        synchronized (list) {
            long longest = 0L;
            for (CullContainer container : this.containers) {
                longest = Math.max(longest, container.getAverageCullTime());
            }
            return longest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCombinedLastRayStepCount() {
        long sum = 0L;
        List<CullContainer> list = this.containers;
        synchronized (list) {
            for (CullContainer container : this.containers) {
                sum += container.getLastRayStepCount();
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleCulling(boolean enabled) {
        this.culling = enabled;
        List<CullContainer> list = this.containers;
        synchronized (list) {
            for (CullContainer container : this.containers) {
                container.toggleCulling(enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String debugContainersFormat() {
        int running = 0;
        int parked = 0;
        List<CullContainer> list = this.containers;
        synchronized (list) {
            for (CullContainer container : this.containers) {
                if (container.getParkReason() == CullContainer.ParkReason.TIME_LEFT) {
                    ++running;
                    continue;
                }
                ++parked;
            }
        }
        return "Containers R: " + running + " P: " + parked + " T: " + this.containers.size() + " R: " + this.getCombinedLastRayStepCount();
    }

    public boolean isCullingEnabled() {
        return this.culling;
    }

    public YamlConfigHolder<PlayerCullingConfig> getConfig() {
        return this.config;
    }

    public IPlatform getPlatform() {
        return this.platform;
    }

    public PlayerCullingUpdater getUpdater() {
        return this.updater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cleanContainers(boolean force) {
        AtomicInteger cleaned = new AtomicInteger();
        List<CullContainer> list = this.containers;
        synchronized (list) {
            this.containers.sort(Comparator.comparing(CullContainer::getPlayerCount).reversed().thenComparingLong(CullContainer::getAverageCullTime));
            if (this.containers.size() >= 2) {
                CullContainer first = this.containers.getFirst();
                CullContainer second = this.containers.get(1);
                if (second.getPlayerCount() > 0) {
                    long combinedCullTime;
                    if (first.getAverageCullTime() > second.getAverageCullTime()) {
                        CullContainer temp = first;
                        first = second;
                        second = temp;
                    }
                    if ((double)(combinedCullTime = first.getAverageCullTime() + second.getAverageCullTime()) < this.config.getDelegate().scheduler.getMaxMergeNs()) {
                        first.mergeInto(second);
                        second.mergeInto(first);
                        LOGGER.info("Container {} merged into {}", (Object)second.getName(), (Object)first.getName());
                        this.platform.runTaskLaterAsync(() -> this.cleanContainers(force), 1000L);
                    }
                }
            }
            this.containers.removeIf(container -> {
                if (this.containers.size() <= 1) {
                    return false;
                }
                if (container.getParkReason() == CullContainer.ParkReason.NO_PLAYERS && (force || container.getTtl() <= 0L)) {
                    container.interrupt();
                    LockSupport.unpark(container);
                    try {
                        container.join(5000L);
                        LOGGER.info("Container {} cleaned up", (Object)container.getName());
                    }
                    catch (InterruptedException exception) {
                        LOGGER.error("Failed to stop container", (Throwable)exception);
                    }
                    cleaned.getAndIncrement();
                    return true;
                }
                return false;
            });
        }
        return cleaned.get();
    }
}

