/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.updater;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.platformcommon.config.PlayerCullingConfig;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformPlayer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public final class PlayerCullingUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PlayerCullingUpdater");
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();
    private static final Gson GSON = new Gson();
    private static final Component PREFIX = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'[', (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"PlayerCulling", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.GRAY))).build();
    private static final String GITHUB_REPO = "MinceraftMC/PlayerCulling";
    private final CullShip ship;
    private final Set<UUID> notifiedPlayers = new HashSet<UUID>();
    private final Manifest manifest = this.loadManifest();
    private final boolean isDev = !"[build]".equals(this.manifest.getMainAttributes().getValue("Environment"));
    private UpdateState state = UpdateState.NOT_CHECKED;
    private @Nullable String downloadUrl = null;
    private @Nullable String updateInfo = null;

    public PlayerCullingUpdater(CullShip ship) {
        this.ship = ship;
    }

    public void enable() {
        if (this.isDev) {
            LOGGER.warn("Running in development environment! Updates will not be checked.");
            return;
        }
        this.ship.getConfig().addReloadHookAndRun(new Consumer<PlayerCullingConfig>(){
            private int taskId = -1;

            @Override
            public void accept(PlayerCullingConfig config) {
                PlayerCullingUpdater.this.ship.getPlatform().cancelTask(this.taskId);
                if (config.updater.enabled) {
                    this.taskId = PlayerCullingUpdater.this.ship.getPlatform().runTaskRepeatingAsync(PlayerCullingUpdater.this::checkForUpdate, 0L, config.updater.getIntervalMs());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForUpdate() {
        boolean notifyPlayers = true;
        try {
            LOGGER.info("Checking for updates...");
            HttpRequest request = HttpRequest.newBuilder(URI.create("https://api.github.com/repos/MinceraftMC/PlayerCulling/releases")).build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                LOGGER.warn("Failed to check for updates: Received {}", (Object)response.statusCode());
                this.state = UpdateState.UPDATE_REQUEST_FAILED;
                return;
            }
            JsonArray versions = (JsonArray)GSON.fromJson(response.body(), JsonArray.class);
            if (versions.isEmpty()) {
                LOGGER.warn("Failed to check for updates: No versions found");
                this.state = UpdateState.UPDATE_REQUEST_FAILED;
                return;
            }
            JsonObject latestRelease = versions.get(0).getAsJsonObject();
            String latestTag = latestRelease.get("tag_name").getAsString();
            String currentTag = this.manifest.getMainAttributes().getValue("Git-Tag");
            if (currentTag.equals(latestTag)) {
                LOGGER.info("PlayerCulling version {} is up-to-date :)", (Object)currentTag);
                this.state = UpdateState.UP_TO_DATE;
                notifyPlayers = false;
            } else {
                String updateInfo = currentTag + " -> " + latestTag;
                if (Objects.equals(this.updateInfo, updateInfo)) {
                    notifyPlayers = false;
                }
                this.updateInfo = updateInfo;
                LOGGER.info("Update found: {}", (Object)updateInfo);
                this.downloadUrl = latestRelease.get("html_url").getAsString();
                this.state = UpdateState.AVAILABLE;
            }
        }
        catch (Throwable throwable) {
            LOGGER.warn("Please report the following error to the developer:", throwable);
            this.state = UpdateState.UPDATE_REQUEST_FAILED;
        }
        finally {
            if (notifyPlayers) {
                this.notifiedPlayers.clear();
                this.notifyPlayers();
            }
        }
    }

    private void notifyPlayer(PlatformPlayer player) {
        TextComponent message;
        if (!this.notifiedPlayers.add(player.getUniqueId())) {
            return;
        }
        switch (this.state.ordinal()) {
            case 1: {
                TextComponent textComponent = Component.text((String)"Failed to check for updates, please check the log for more info", (TextColor)NamedTextColor.RED);
                break;
            }
            case 3: {
                TextComponent textComponent;
                if (this.updateInfo == null || this.downloadUrl == null) {
                    textComponent = Component.text((String)"Update available, but no information available", (TextColor)NamedTextColor.RED);
                    break;
                }
                textComponent = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Update available ").color((TextColor)NamedTextColor.YELLOW)).append((Component)Component.text((char)'(', (TextColor)NamedTextColor.GRAY))).append(((TextComponent)Component.text((String)this.updateInfo, (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.UNDERLINED}).hoverEvent((HoverEventSource)Component.text((String)this.downloadUrl, (TextColor)NamedTextColor.GRAY))).clickEvent(ClickEvent.openUrl((String)this.downloadUrl)))).append((Component)Component.text((char)')', (TextColor)NamedTextColor.GRAY))).build();
                break;
            }
            default: {
                TextComponent textComponent = message = null;
            }
        }
        if (message != null) {
            player.sendMessage(PREFIX.append((Component)message));
        }
    }

    private void notifyPlayers() {
        if (!this.ship.getConfig().getDelegate().updater.notifyAdmins) {
            return;
        }
        for (PlatformPlayer platformPlayer : this.ship.getPlatform().getPlayers()) {
            if (!platformPlayer.hasPermission("playerculling.update-notify")) continue;
            this.notifyPlayer(platformPlayer);
        }
    }

    public void onJoin(PlatformPlayer player) {
        if (!this.ship.getConfig().getDelegate().updater.notifyAdmins) {
            return;
        }
        if (player.hasPermission("playerculling.update-notify")) {
            this.notifyPlayer(player);
        }
    }

    private Manifest loadManifest() {
        Manifest manifest;
        block8: {
            InputStream resource = PlayerCullingUpdater.class.getResourceAsStream("/META-INF/MANIFEST.MF");
            try {
                Manifest manifest2 = new Manifest(resource);
                Attributes mainAttributes = manifest2.getMainAttributes();
                LOGGER.info("Loaded manifest: {} {}, {}/{}({}) - Environment: {} - Licensed under {} on {}", new Object[]{mainAttributes.getValue("Implementation-Title"), mainAttributes.getValue("Implementation-Version"), mainAttributes.getValue("Git-Commit"), mainAttributes.getValue("Git-Branch"), mainAttributes.getValue("Git-Tag"), mainAttributes.getValue("Environment"), mainAttributes.getValue("License"), mainAttributes.getValue("Build-Date")});
                manifest = manifest2;
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new RuntimeException("Failed to load manifest", exception);
                }
            }
            resource.close();
        }
        return manifest;
    }

    private static enum UpdateState {
        NOT_CHECKED,
        UPDATE_REQUEST_FAILED,
        UP_TO_DATE,
        AVAILABLE;

    }
}

