/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformcommon.platform.world;

import de.pianoman911.playerculling.platformcommon.cache.OcclusionWorldCache;
import de.pianoman911.playerculling.platformcommon.platform.IPlatform;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformPlayer;
import de.pianoman911.playerculling.platformcommon.platform.world.PlatformChunkAccess;
import de.pianoman911.playerculling.platformcommon.util.TickRefreshSupplier;
import de.pianoman911.playerculling.platformcommon.vector.Vec3d;
import de.pianoman911.playerculling.platformcommon.vector.Vec3i;
import java.awt.Color;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PlatformWorld {
    protected final OcclusionWorldCache cache = new OcclusionWorldCache(this);
    protected final TickRefreshSupplier<List<PlatformPlayer>> playersInWorld;

    public PlatformWorld(IPlatform platform) {
        this.playersInWorld = new TickRefreshSupplier<List>(platform, this::getPlayers0);
    }

    public OcclusionWorldCache getOcclusionWorldCache() {
        return this.cache;
    }

    public abstract @Nullable PlatformChunkAccess getChunkAccess(int var1, int var2);

    public abstract String getName();

    public abstract int getMinY();

    public abstract int getMaxY();

    public abstract int getTrackingDistance();

    public abstract int getTrackingDistance(PlatformPlayer var1);

    public List<PlatformPlayer> getPlayers() {
        return this.playersInWorld.get();
    }

    public int getPlayerCount() {
        return this.playersInWorld.get().size();
    }

    protected abstract List<PlatformPlayer> getPlayers0();

    public abstract @Nullable Vec3d rayTraceBlocks(Vec3d var1, Vec3d var2, double var3);

    public abstract void spawnColoredParticle(double var1, double var3, double var5, Color var7, float var8);

    public void spawnColoredParticle(Vec3d pos, Color color, float size) {
        this.spawnColoredParticle(pos.getX(), pos.getY(), pos.getZ(), color, size);
    }

    public abstract String getBlockStateStringOfBlock(Vec3i var1);
}

