/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformcommon.util;

import de.pianoman911.playerculling.platformcommon.platform.IPlatform;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class TickRefreshSupplier<T>
implements Supplier<T> {
    private final IPlatform platform;
    private final Supplier<T> delegate;
    private volatile long lastTick;
    private volatile @MonotonicNonNull T value;

    public TickRefreshSupplier(IPlatform platform, Supplier<T> delegate) {
        this.platform = platform;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        long currentTick = this.platform.getCurrentTick();
        if (this.lastTick != currentTick) {
            TickRefreshSupplier tickRefreshSupplier = this;
            synchronized (tickRefreshSupplier) {
                if (this.lastTick != currentTick) {
                    T value = this.delegate.get();
                    this.value = value;
                    this.lastTick = currentTick;
                    return value;
                }
            }
        }
        return this.value;
    }
}

