/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformfolianms1216;

import de.pianoman911.playerculling.platformcommon.util.OcclusionMappings;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class BlockStateUtil {
    public static boolean[] buildVoxelShape(BlockState state, ServerLevel world) {
        if (state == null) {
            return OcclusionMappings.EMPTY_CUBE;
        }
        if (!state.canOcclude()) {
            return OcclusionMappings.EMPTY_CUBE;
        }
        if (state.moonrise$occludesFullBlock()) {
            return OcclusionMappings.FULL_CUBE;
        }
        VoxelShape shape = state.getShape((BlockGetter)world, BlockPos.ZERO);
        List nms = shape.toAabbs();
        boolean[] shapes = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            double minX = (double)(i & 1) * 0.5;
            double minY = (double)(i >> 1 & 1) * 0.5;
            double minZ = (double)(i >> 2 & 1) * 0.5;
            double maxX = minX + 0.5;
            double maxY = minY + 0.5;
            double maxZ = minZ + 0.5;
            boolean contains = false;
            for (AABB aabb : nms) {
                if (!BlockStateUtil.boxContainsBox(aabb, minX, minY, minZ, maxX, maxY, maxZ)) continue;
                contains = true;
                break;
            }
            shapes[i] = contains;
        }
        return shapes;
    }

    private static final boolean boxContainsBox(AABB outer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return outer.minX <= minX && outer.minY <= minY && outer.minZ <= minZ && outer.maxX >= maxX && outer.maxY >= maxY && outer.maxZ >= maxZ;
    }
}

