/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.platformpaper.platform;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.pianoman911.playerculling.platformcommon.platform.command.BlockPosResolver;
import de.pianoman911.playerculling.platformcommon.platform.command.MultiPlayerResolver;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformArgument;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformArgumentProvider;
import de.pianoman911.playerculling.platformcommon.platform.command.ResultConverter;
import de.pianoman911.playerculling.platformcommon.platform.command.SinglePlayerResolver;
import de.pianoman911.playerculling.platformcommon.vector.Vec3i;
import de.pianoman911.playerculling.platformpaper.platform.PaperCommandSourceStack;
import de.pianoman911.playerculling.platformpaper.platform.PaperPlatform;
import de.pianoman911.playerculling.platformpaper.platform.PaperPlayer;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import io.papermc.paper.math.BlockPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

public class PaperArgumentsProvider
implements PlatformArgumentProvider {
    private final PaperPlatform platform;

    public PaperArgumentsProvider(PaperPlatform platform) {
        this.platform = platform;
    }

    @Override
    public ArgumentType<BlockPosResolver> blockPos() {
        return this.wrap(ArgumentTypes.blockPosition(), paper -> src -> {
            BlockPosition resolved = (BlockPosition)paper.resolve(((PaperCommandSourceStack)src).getPaperSourceStack());
            return new Vec3i(resolved.blockX(), resolved.blockY(), resolved.blockZ());
        });
    }

    @Override
    public ArgumentType<SinglePlayerResolver> player() {
        return this.wrap(ArgumentTypes.player(), paper -> src -> {
            Player player = (Player)((List)paper.resolve(((PaperCommandSourceStack)src).getPaperSourceStack())).getFirst();
            return this.platform.providePlayer(player);
        });
    }

    @Override
    public ArgumentType<MultiPlayerResolver> players() {
        return this.wrap(ArgumentTypes.players(), paper -> src -> {
            List resolved = (List)paper.resolve(((PaperCommandSourceStack)src).getPaperSourceStack());
            ArrayList<PaperPlayer> players = new ArrayList<PaperPlayer>(resolved.size());
            for (Player player : resolved) {
                players.add(this.platform.providePlayer(player));
            }
            return players;
        });
    }

    private <B, C> ArgumentType<C> wrap(ArgumentType<B> base, ResultConverter<B, C> converter) {
        return new PaperWrapperArgumentType<B, C>(base, converter);
    }

    @NullMarked
    public static final class PaperWrapperArgumentType<P, C>
    implements CustomArgumentType<C, P>,
    PlatformArgument<P, C> {
        private final ArgumentType<P> paperBase;
        private final ResultConverter<P, C> converter;

        private PaperWrapperArgumentType(ArgumentType<P> nmsBase, ResultConverter<P, C> converter) {
            this.paperBase = nmsBase;
            this.converter = converter;
        }

        public C parse(StringReader reader) throws CommandSyntaxException {
            return this.converter.convert(this.paperBase.parse(reader));
        }

        public <S> C parse(StringReader reader, S source) throws CommandSyntaxException {
            return this.converter.convert(this.paperBase.parse(reader, source));
        }

        public ArgumentType<P> getNativeType() {
            return this.paperBase;
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return this.paperBase.listSuggestions(context, builder);
        }

        @Override
        public C convertToPlatform(P obj) throws CommandSyntaxException {
            return this.converter.convert(obj);
        }
    }
}

