/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class FluidRenderer {
    public static final FluidRenderer INSTANCE = new FluidRenderer(16);
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private final int width;

    public FluidRenderer(int width) {
        this.width = width;
    }

    public void render(GuiGraphics gfx, int xPosition, int yPosition, FluidStack stack, int height) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.drawFluid(gfx, xPosition, yPosition, stack, height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void drawFluid(GuiGraphics gfx, int xPosition, int yPosition, FluidStack stack, int height) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return;
        }
        TextureAtlasSprite fluidStillSprite = this.getStillFluidSprite(stack);
        IClientFluidTypeExtensions prop = IClientFluidTypeExtensions.of((Fluid)fluid);
        int color = prop.getTintColor(stack);
        this.drawTiledSprite(gfx, xPosition, yPosition, this.width, height, color, (float)stack.getAmount() / 1000000.0f, fluidStillSprite);
    }

    private void drawTiledSprite(GuiGraphics gfx, int xPosition, int yPosition, int width, int height, int color, float scaledAmount, TextureAtlasSprite sprite) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        FluidRenderer.setGLColorFromInt(color);
        gfx.m_280159_(xPosition, yPosition, 100, width, height, sprite);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private TextureAtlasSprite getStillFluidSprite(FluidStack stack) {
        Minecraft minecraft = Minecraft.m_91087_();
        Fluid fluid = stack.getFluid();
        IClientFluidTypeExtensions prop = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = prop.getStillTexture();
        return (TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }
}

