/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.client.structure;

import io.ticticboom.mods.mm.structure.StructureModel;
import io.ticticboom.mods.mm.structure.layout.PositionedLayoutPiece;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.lwjgl.glfw.GLFW;

public class AutoTransform {
    private static Minecraft mc = Minecraft.m_91087_();
    private int lastX = 0;
    private int lastY = 0;
    private double xRotation;
    private double yRotation;
    private double scrollLastPos = 0.0;
    private double scaleFactor = 1.0;
    private Vector3i minBound = new Vector3i(Integer.MAX_VALUE);
    private Vector3i maxBound = new Vector3i(Integer.MIN_VALUE);
    private Vector3f pan;
    private Vector3f offset;

    public AutoTransform(StructureModel model) {
        for (PositionedLayoutPiece piece : model.layout().getPositionedPieces()) {
            BlockPos pos = piece.pos();
            this.minBound.x = Math.min(pos.m_123341_(), this.minBound.x);
            this.minBound.y = Math.min(pos.m_123342_(), this.minBound.y);
            this.minBound.z = Math.min(pos.m_123343_(), this.minBound.z);
            this.maxBound.x = Math.max(pos.m_123341_(), this.maxBound.x);
            this.maxBound.y = Math.max(pos.m_123342_(), this.maxBound.y);
            this.maxBound.z = Math.max(pos.m_123343_(), this.maxBound.z);
        }
        this.reset();
    }

    public void run(int mouseX, int mouseY) {
        if (this.lastX == 0 && this.lastY == 0) {
            this.lastX = mouseX;
            this.lastY = mouseY;
        }
        if (GLFW.glfwGetMouseButton((long)mc.m_91268_().m_85439_(), (int)1) == 1) {
            this.scaleFactor += ((double)mouseY - (double)this.lastY) * (double)0.05f;
            this.scaleFactor = Math.max((double)0.003f, this.scaleFactor);
        }
        if (GLFW.glfwGetMouseButton((long)mc.m_91268_().m_85439_(), (int)2) == 1) {
            double mx = (double)mouseX - (double)this.lastX;
            double my = (double)mouseY - (double)this.lastY;
            this.xRotation += mx;
            this.yRotation += my;
        }
        if (GLFW.glfwGetMouseButton((long)mc.m_91268_().m_85439_(), (int)0) == 1 && GLFW.glfwGetKey((long)mc.m_91268_().m_85439_(), (int)340) == 1) {
            double relMoveX = mouseX - this.lastX;
            double relMoveY = mouseY - this.lastY;
            this.pan.add((float)relMoveX * 0.08f, (float)(-relMoveY) * 0.08f, 0.0f);
        }
        float centerX = ((float)this.maxBound.x - (float)this.minBound.x) / 2.0f;
        float centerY = ((float)this.maxBound.y - (float)this.minBound.y) / 2.0f;
        float centerZ = ((float)this.maxBound.z - (float)this.minBound.z) / 2.0f;
        this.offset = new Vector3f((float)this.minBound.x, (float)this.minBound.y, (float)this.minBound.z);
        this.offset.add(centerX, centerY, centerZ);
        this.offset.add(-0.5f, -0.5f, -0.5f);
        this.lastX = mouseX;
        this.lastY = mouseY;
    }

    public Matrix4f transform(Matrix4f m, BlockPos pos) {
        m.scale(12.0f, -12.0f, 12.0f);
        m.translate((Vector3fc)this.pan);
        m.rotate((Quaternionfc)new Quaternionf(new AxisAngle4f((float)this.yRotation * ((float)Math.PI / 180), 1.0f, 0.0f, 0.0f)));
        m.rotate((Quaternionfc)new Quaternionf(new AxisAngle4f(-((float)this.xRotation) * ((float)Math.PI / 180), 0.0f, -1.0f, 0.0f)));
        m.scale((float)this.scaleFactor, (float)this.scaleFactor, (float)this.scaleFactor);
        m.translate((float)pos.m_123341_() + this.offset.x, (float)pos.m_123342_() + this.offset.y, (float)pos.m_123343_() + this.offset.z);
        return m;
    }

    public void reset() {
        this.xRotation = -35.0;
        this.yRotation = 15.0;
        this.lastX = 0;
        this.lastY = 0;
        this.scaleFactor = 1.5;
        float tx = 6.75f;
        float ty = -6.0f;
        float tz = 10.0f;
        this.pan = new Vector3f(tx, ty, tz);
    }

    public int getLastX() {
        return this.lastX;
    }

    public int getLastY() {
        return this.lastY;
    }

    public double getXRotation() {
        return this.xRotation;
    }

    public double getYRotation() {
        return this.yRotation;
    }

    public double getScrollLastPos() {
        return this.scrollLastPos;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public Vector3i getMinBound() {
        return this.minBound;
    }

    public Vector3i getMaxBound() {
        return this.maxBound;
    }

    public Vector3f getPan() {
        return this.pan;
    }

    public Vector3f getOffset() {
        return this.offset;
    }

    public void setLastX(int lastX) {
        this.lastX = lastX;
    }

    public void setLastY(int lastY) {
        this.lastY = lastY;
    }

    public void setXRotation(double xRotation) {
        this.xRotation = xRotation;
    }

    public void setYRotation(double yRotation) {
        this.yRotation = yRotation;
    }

    public void setScrollLastPos(double scrollLastPos) {
        this.scrollLastPos = scrollLastPos;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public void setMinBound(Vector3i minBound) {
        this.minBound = minBound;
    }

    public void setMaxBound(Vector3i maxBound) {
        this.maxBound = maxBound;
    }

    public void setPan(Vector3f pan) {
        this.pan = pan;
    }

    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }
}

