/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.client.structure;

import com.mojang.blaze3d.vertex.PoseStack;
import io.ticticboom.mods.mm.client.structure.AutoTransform;
import io.ticticboom.mods.mm.piece.modifier.StructurePieceModifier;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class GuiBlockRenderer {
    private final Block block;
    private BlockEntityRenderer<BlockEntity> ber;
    private BlockEntity be;
    private BlockState state;
    private final List<StructurePieceModifier> modifiers;
    private static Minecraft mc = Minecraft.m_91087_();
    private BlockPos pos;

    public GuiBlockRenderer(Block block, List<StructurePieceModifier> modifiers) {
        this.block = block;
        this.modifiers = modifiers;
    }

    public void setupAt(BlockPos pos) {
        this.pos = pos;
        this.state = this.block.m_49966_();
        Block block = this.block;
        if (block instanceof EntityBlock) {
            EntityBlock eb = (EntityBlock)block;
            this.be = eb.m_142194_(pos, this.state);
            this.ber = Minecraft.m_91087_().m_167982_().m_112265_(this.be);
        }
        for (StructurePieceModifier mod : this.modifiers) {
            this.state = mod.modifyBlockState(this.state, this.be, pos);
            if (this.be == null) continue;
            this.be = mod.modifyBlockEntity(this.state, this.be, pos);
        }
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, AutoTransform mouseTransform) {
        PoseStack pose = gfx.m_280168_();
        pose.m_85836_();
        mouseTransform.transform(pose.m_85850_().m_252922_(), this.pos);
        BlockRenderDispatcher brd = mc.m_91289_();
        MultiBufferSource.BufferSource bufferSource = gfx.m_280091_();
        ModelData modeldata = this.be != null ? this.be.getModelData() : ModelData.EMPTY;
        BakedModel model = brd.m_110910_(this.state);
        int color = mc.m_91298_().m_92577_(this.state, null, this.pos, 0);
        color = color == -1 ? 0xFFFFFF : color;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderType renderType = ItemBlockRenderTypes.m_109284_((BlockState)this.state, (boolean)true);
        brd.renderSingleBlock(this.state, pose, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, modeldata, renderType);
        if (this.ber != null) {
            try {
                this.ber.m_6922_(this.be, 1.0f, gfx.m_280168_(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        bufferSource.m_109911_();
        pose.m_85849_();
    }
}

