/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.compat.jei;

import com.google.common.collect.ImmutableList;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.compat.jei.category.MMRecipeCategory;
import io.ticticboom.mods.mm.compat.jei.category.MMStructureCategory;
import io.ticticboom.mods.mm.compat.jei.ingredient.MMJeiIngredients;
import io.ticticboom.mods.mm.compat.jei.ingredient.energy.EnergyIngredientHelper;
import io.ticticboom.mods.mm.compat.jei.ingredient.energy.EnergyIngredientRenderer;
import io.ticticboom.mods.mm.compat.jei.ingredient.mana.BotaniaManaIngredientHelper;
import io.ticticboom.mods.mm.compat.jei.ingredient.mana.BotaniaManaIngredientRenderer;
import io.ticticboom.mods.mm.compat.jei.ingredient.pncr.PneumaticAirIngredientHelper;
import io.ticticboom.mods.mm.compat.jei.ingredient.pncr.PneumaticAirIngredientRender;
import io.ticticboom.mods.mm.config.MMConfig;
import io.ticticboom.mods.mm.recipe.MachineRecipeManager;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import io.ticticboom.mods.mm.setup.MMRegisters;
import io.ticticboom.mods.mm.structure.StructureManager;
import io.ticticboom.mods.mm.structure.StructureModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class MMJeiPlugin
implements IModPlugin {
    public static final ResourceLocation UID = Ref.id("jei_plugin");
    public static final List<MMRecipeCategory> recipeCategories = new ArrayList<MMRecipeCategory>();

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (MMConfig.JEI_RECIPE_SPLIT) {
            for (StructureModel parentStructure : StructureManager.STRUCTURES.values()) {
                this.registerProcessRecipe(registration, parentStructure);
            }
        } else {
            this.registerProcessRecipe(registration, null);
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new MMStructureCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    private void registerProcessRecipe(IRecipeCategoryRegistration registration, StructureModel parent) {
        MMRecipeCategory category = new MMRecipeCategory(registration.getJeiHelpers(), parent);
        registration.addRecipeCategories(new IRecipeCategory[]{category});
        recipeCategories.add(category);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (MMConfig.JEI_RECIPE_SPLIT) {
            for (MMRecipeCategory entry : recipeCategories) {
                List<RecipeModel> recipes = MachineRecipeManager.RECIPES.values().stream().filter(x -> x.structureId().equals((Object)entry.getStructureModel().id())).toList();
                registration.addRecipes(entry.getRecipeType(), recipes);
            }
        } else {
            registration.addRecipes(MMRecipeCategory.RECIPE_TYPE, new ArrayList<RecipeModel>(MachineRecipeManager.RECIPES.values()));
        }
        registration.addRecipes(MMStructureCategory.RECIPE_TYPE, new ArrayList<StructureModel>(StructureManager.STRUCTURES.values()));
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register((IIngredientType)MMJeiIngredients.ENERGY, (Collection)ImmutableList.of(), (IIngredientHelper)new EnergyIngredientHelper(), (IIngredientRenderer)new EnergyIngredientRenderer());
        registration.register((IIngredientType)MMJeiIngredients.PNEUMATIC_AIR, (Collection)ImmutableList.of(), (IIngredientHelper)new PneumaticAirIngredientHelper(), (IIngredientRenderer)new PneumaticAirIngredientRender());
        registration.register((IIngredientType)MMJeiIngredients.BOTANIA_MANA, (Collection)ImmutableList.of(), (IIngredientHelper)new BotaniaManaIngredientHelper(), (IIngredientRenderer)new BotaniaManaIngredientRenderer());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (MMRecipeCategory entry : recipeCategories) {
            ResourceLocation location = entry.getStructureModel().controllerIds().getIds().get(0);
            ItemStack stack = ((Item)ForgeRegistries.ITEMS.getValue(location)).m_7968_();
            registration.addRecipeCatalyst(stack, new RecipeType[]{entry.getRecipeType()});
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{(Item)MMRegisters.BLUEPRINT.get()});
    }
}

