/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.controller;

import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.controller.ControllerType;
import io.ticticboom.mods.mm.controller.IControllerPart;
import io.ticticboom.mods.mm.controller.machine.MachineControllerType;
import io.ticticboom.mods.mm.setup.RegistryGroupHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class MMControllerRegistry {
    private static Map<ResourceLocation, ControllerType> CONTROLLER_TYPES = new HashMap<ResourceLocation, ControllerType>();
    public static List<RegistryGroupHolder> CONTROLLERS = new ArrayList<RegistryGroupHolder>();

    public static void init() {
        MMControllerRegistry.register(Ref.Controller.MACHINE, new MachineControllerType());
    }

    public static ControllerType get(ResourceLocation id) {
        return CONTROLLER_TYPES.get(id);
    }

    public static void register(ResourceLocation id, ControllerType type) {
        CONTROLLER_TYPES.put(id, type);
    }

    public static Collection<ControllerType> getControllers() {
        return CONTROLLER_TYPES.values();
    }

    public static Item getControllerItem(ResourceLocation id) {
        for (RegistryGroupHolder holder : CONTROLLERS) {
            IControllerPart part;
            Item item = (Item)holder.getItem().get();
            if (!(item instanceof IControllerPart) || !(part = (IControllerPart)item).getModel().id().equals(id.m_135815_())) continue;
            return item;
        }
        return null;
    }

    public static Block getControllerBlock(ResourceLocation id) {
        for (RegistryGroupHolder holder : CONTROLLERS) {
            IControllerPart part;
            Block block = (Block)holder.getBlock().get();
            if (!(block instanceof IControllerPart) || !(part = (IControllerPart)block).getModel().id().equals(id.m_135815_())) continue;
            return block;
        }
        return null;
    }
}

