/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.datagen.provider;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.controller.IControllerPart;
import io.ticticboom.mods.mm.extra.IExtraBlockPart;
import io.ticticboom.mods.mm.port.IPortPart;
import io.ticticboom.mods.mm.setup.MMRegisters;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;

public class MMLootTableProvider
extends LootTableProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator generator;

    public MMLootTableProvider(DataGenerator generator) {
        super(generator.getPackOutput(), (Set)ImmutableSet.of(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(MMLootTableSubProvider::new, LootContextParamSets.f_81421_)));
        this.generator = generator;
    }

    public static class MMLootTableSubProvider
    implements LootTableSubProvider {
        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            for (RegistryObject blockEntry : MMRegisters.BLOCKS.getEntries()) {
                Block block = (Block)blockEntry.get();
                if (block instanceof IControllerPart) {
                    IControllerPart controllerPart = (IControllerPart)block;
                    consumer.accept(Ref.id("blocks/" + controllerPart.getModel().id()), this.createBlockLootTable(block));
                }
                if (block instanceof IPortPart) {
                    IPortPart portPart = (IPortPart)block;
                    consumer.accept(Ref.id("blocks/" + portPart.getModel().id()), this.createBlockLootTable(block));
                }
                if (!(block instanceof IExtraBlockPart)) continue;
                IExtraBlockPart extra = (IExtraBlockPart)block;
                consumer.accept(Ref.id("blocks/" + extra.getModel().id()), this.createBlockLootTable(block));
            }
        }

        protected LootTable.Builder createBlockLootTable(Block block) {
            LootPool.Builder builder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block));
            return LootTable.m_79147_().m_79161_(builder);
        }
    }
}

