/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.piece.type.block;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.piece.StructurePieceSetupMetadata;
import io.ticticboom.mods.mm.piece.type.StructurePiece;
import io.ticticboom.mods.mm.structure.StructureModel;
import io.ticticboom.mods.mm.util.StructurePieceUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStructurePiece
extends StructurePiece {
    private final ResourceLocation blockId;
    private Block block;

    public BlockStructurePiece(ResourceLocation blockId) {
        this.blockId = blockId;
    }

    @Override
    public void validateSetup(StructurePieceSetupMetadata meta) {
        this.block = (Block)ForgeRegistries.BLOCKS.getValue(this.blockId);
        if (this.block == null) {
            throw new RuntimeException(StructurePieceUtils.errorMessageFor("'block' field is not a valid block id", meta));
        }
        this.setup = true;
    }

    @Override
    public boolean formed(Level level, BlockPos pos, StructureModel model) {
        if (this.block == null) {
            this.block = (Block)ForgeRegistries.BLOCKS.getValue(this.blockId);
        }
        return level.m_8055_(pos).m_60713_(this.block);
    }

    @Override
    public Supplier<List<Block>> createBlocksSupplier() {
        return () -> List.of(this.block);
    }

    @Override
    public Component createDisplayComponent() {
        return Component.m_237113_((String)"Block Id: ").m_7220_((Component)Component.m_237113_((String)this.blockId.toString()).m_130940_(ChatFormatting.DARK_AQUA));
    }

    @Override
    public JsonObject debugExpected(Level level, BlockPos pos, StructureModel model, JsonObject json) {
        json.addProperty("block", this.blockId.toString());
        return json;
    }

    @Override
    public JsonObject debugFound(Level level, BlockPos pos, StructureModel model, JsonObject json) {
        ResourceLocation foundId = ForgeRegistries.BLOCKS.getKey((Object)level.m_8055_(pos).m_60734_());
        json.addProperty("block", foundId.toString());
        return json;
    }
}

