/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.botania.mana;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.IPortStorageModel;
import io.ticticboom.mods.mm.port.botania.mana.BotaniaManaPortStorageModel;
import io.ticticboom.mods.mm.port.common.INotifyChangeFunction;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class BotaniaManaPortStorage
implements IPortStorage {
    private final BotaniaManaPortStorageModel model;
    private final INotifyChangeFunction changed;
    private final UUID uid = UUID.randomUUID();
    private int capacity;
    private int stored = 0;

    public BotaniaManaPortStorage(BotaniaManaPortStorageModel model, INotifyChangeFunction changed) {
        this.model = model;
        this.changed = changed;
        this.capacity = model.capacity();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        return LazyOptional.empty();
    }

    @Override
    public <T> boolean hasCapability(Capability<T> capability) {
        return false;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag.m_128405_("stored", this.stored);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        this.stored = tag.m_128451_("stored");
    }

    @Override
    public IPortStorageModel getStorageModel() {
        return this.model;
    }

    @Override
    public UUID getStorageUid() {
        return this.uid;
    }

    @Override
    public JsonObject debugDump() {
        return null;
    }

    public int receiveMana(int mana, boolean sim) {
        mana = Math.abs(mana);
        int canBeFilled = Math.min(this.capacity - this.stored, mana);
        if (!sim) {
            this.stored += canBeFilled;
            this.changed.call();
        }
        return canBeFilled;
    }

    public int extractMana(int mana, boolean sim) {
        mana = Math.abs(mana);
        int canBeDrained = Math.min(this.stored, mana);
        if (!sim) {
            this.stored -= canBeDrained;
            this.changed.call();
        }
        return canBeDrained;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getStored() {
        return this.stored;
    }

    public void setStored(int stored) {
        this.stored = stored;
    }
}

