/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.energy;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.cap.MMCapabilities;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.IPortStorageModel;
import io.ticticboom.mods.mm.port.common.INotifyChangeFunction;
import io.ticticboom.mods.mm.port.energy.EnergyPortHandler;
import io.ticticboom.mods.mm.port.energy.EnergyPortStorageModel;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyPortStorage
implements IPortStorage {
    private final EnergyPortStorageModel model;
    private final EnergyPortHandler handler;
    private final LazyOptional<IEnergyStorage> handlerLazyOptional;
    private final UUID uid = UUID.randomUUID();

    public EnergyPortStorage(EnergyPortStorageModel model, INotifyChangeFunction changed) {
        this.model = model;
        this.handler = new EnergyPortHandler(model.capacity(), model.maxReceive(), model.maxExtract(), changed);
        this.handlerLazyOptional = LazyOptional.of(() -> this.handler);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        if (this.hasCapability(capability)) {
            return this.handlerLazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public <T> boolean hasCapability(Capability<T> capability) {
        return MMCapabilities.ENERGY == capability;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag.m_128365_("handler", this.handler.serializeNBT());
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        this.handler.deserializeNBT(tag.m_128423_("handler"));
    }

    @Override
    public IPortStorageModel getStorageModel() {
        return this.model;
    }

    @Override
    public UUID getStorageUid() {
        return this.uid;
    }

    @Override
    public JsonObject debugDump() {
        JsonObject dump = new JsonObject();
        dump.addProperty("uid", this.uid.toString());
        dump.addProperty("stored", (Number)this.handler.getEnergyStored());
        dump.addProperty("maxReceive", (Number)this.model.maxReceive());
        dump.addProperty("maxExtract", (Number)this.model.maxExtract());
        dump.addProperty("capacity", (Number)this.model.capacity());
        return dump;
    }

    public int internalExtract(int amount, boolean simulate) {
        return this.handler.unboundedExtractEnergy(amount, simulate);
    }

    public int internalInsert(int amount, boolean simulate) {
        return this.handler.unboundedReceiveEnergy(amount, simulate);
    }

    public int getStoredEnergy() {
        return this.handler.getEnergyStored();
    }

    public EnergyPortHandler getHandler() {
        return this.handler;
    }
}

