/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.energy.feature;

import io.ticticboom.mods.mm.port.common.IHandlerCoupling;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHandlerCoupling
implements IHandlerCoupling {
    private final LazyOptional<IEnergyStorage> fromHandler;
    private LazyOptional<IEnergyStorage> toHandler;

    public EnergyHandlerCoupling(LazyOptional<IEnergyStorage> fromHandler, LazyOptional<IEnergyStorage> toHandler) {
        this.fromHandler = fromHandler;
        this.toHandler = toHandler;
    }

    @Override
    public void attemptTransfer() {
        this.toHandler.ifPresent(handler -> this.fromHandler.ifPresent(from -> this.attemptTransfer((IEnergyStorage)from, (IEnergyStorage)handler)));
    }

    private void attemptTransfer(IEnergyStorage from, IEnergyStorage to) {
        int inserted;
        int extracted = from.extractEnergy(from.getMaxEnergyStored(), true);
        if (extracted > 0 && (inserted = to.receiveEnergy(extracted, false)) > 0) {
            from.extractEnergy(inserted, false);
        }
    }

    public LazyOptional<IEnergyStorage> getFromHandler() {
        return this.fromHandler;
    }

    public LazyOptional<IEnergyStorage> getToHandler() {
        return this.toHandler;
    }

    public void setToHandler(LazyOptional<IEnergyStorage> toHandler) {
        this.toHandler = toHandler;
    }
}

