/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.fluid.register;

import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.common.AbstractPortAutoPushFeature;
import io.ticticboom.mods.mm.port.common.AbstractPortBlockEntity;
import io.ticticboom.mods.mm.port.fluid.FluidPortStorage;
import io.ticticboom.mods.mm.port.fluid.FluidPortStorageModel;
import io.ticticboom.mods.mm.port.fluid.feature.FluidPortAutoPushFeature;
import io.ticticboom.mods.mm.port.fluid.register.FluidPortMenu;
import io.ticticboom.mods.mm.setup.RegistryGroupHolder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPortBlockEntity
extends AbstractPortBlockEntity {
    private final PortModel model;
    private final RegistryGroupHolder groupHolder;
    private final boolean isInput;
    private final FluidPortStorage storage;
    private final Optional<FluidPortAutoPushFeature> autoPushAddon;

    public FluidPortBlockEntity(PortModel model, RegistryGroupHolder groupHolder, boolean isInput, BlockPos pos, BlockState state) {
        super((BlockEntityType)groupHolder.getBe().get(), pos, state);
        this.model = model;
        this.groupHolder = groupHolder;
        this.isInput = isInput;
        this.storage = (FluidPortStorage)model.config().createPortStorage(this::m_6596_);
        boolean shouldAutoPush = !isInput && ((FluidPortStorageModel)this.storage.getStorageModel()).autoPush().get() != false;
        this.autoPushAddon = shouldAutoPush ? Optional.of(new FluidPortAutoPushFeature(this, this.model)) : Optional.empty();
    }

    @Override
    public IPortStorage getStorage() {
        return this.storage;
    }

    @Override
    public boolean isInput() {
        return this.isInput;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Fluid Port");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new FluidPortMenu(this.model, this.groupHolder, this.isInput, windowId, inv, this);
    }

    @Override
    public PortModel getModel() {
        return this.model;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return this.storage.getCapability(cap);
    }

    public void tick() {
        this.autoPushAddon.ifPresent(AbstractPortAutoPushFeature::tick);
    }

    public void onLoad() {
        this.autoPushAddon.ifPresent(AbstractPortAutoPushFeature::onLoad);
    }

    public void neighborsChanged() {
        this.autoPushAddon.ifPresent(AbstractPortAutoPushFeature::tryAddNeighboringHandlers);
    }
}

