/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.mekanism.chemical;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.compat.jei.SlotGrid;
import io.ticticboom.mods.mm.port.IPortIngredient;
import io.ticticboom.mods.mm.port.mekanism.chemical.MekanismChemicalPortStorage;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public abstract class MekanismChemicalPortIngredient<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements IPortIngredient {
    protected final ResourceLocation id;
    protected final long amount;
    protected final STACK stack;
    protected final CHEMICAL chemical;

    public abstract STACK createStack(CHEMICAL var1, long var2);

    public abstract CHEMICAL findChemical(ResourceLocation var1);

    public abstract Class<? extends MekanismChemicalPortStorage<CHEMICAL, STACK>> getStorageClass();

    public abstract ResourceLocation getTypeId();

    public MekanismChemicalPortIngredient(ResourceLocation chemical, long amount) {
        this.id = chemical;
        this.amount = amount;
        this.chemical = this.findChemical(this.id);
        this.stack = this.createStack(this.chemical, amount);
    }

    @Override
    public boolean canProcess(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<MekanismChemicalPortStorage<CHEMICAL, STACK>> inputStorages = storages.getInputStorages(this.getStorageClass());
        long remaining = this.amount;
        for (MekanismChemicalPortStorage<CHEMICAL, STACK> storage : inputStorages) {
            STACK extracted = storage.extract(remaining, Action.SIMULATE);
            remaining -= extracted.getAmount();
        }
        return remaining <= 0L;
    }

    @Override
    public void process(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<MekanismChemicalPortStorage<CHEMICAL, STACK>> inputStorages = storages.getInputStorages(this.getStorageClass());
        long remaining = this.amount;
        for (MekanismChemicalPortStorage<CHEMICAL, STACK> storage : inputStorages) {
            STACK extracted = storage.extract(remaining, Action.EXECUTE);
            remaining -= extracted.getAmount();
        }
    }

    @Override
    public boolean canOutput(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<MekanismChemicalPortStorage<CHEMICAL, STACK>> outputStorages = storages.getOutputStorages(this.getStorageClass());
        long remaining = this.amount;
        for (MekanismChemicalPortStorage<CHEMICAL, STACK> storage : outputStorages) {
            STACK inserted = storage.insert(this.createStack(this.chemical, remaining), Action.SIMULATE);
            remaining -= inserted.getAmount();
        }
        return remaining <= 0L;
    }

    @Override
    public void output(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<MekanismChemicalPortStorage<CHEMICAL, STACK>> outputStorages = storages.getOutputStorages(this.getStorageClass());
        long remaining = this.amount;
        for (MekanismChemicalPortStorage<CHEMICAL, STACK> storage : outputStorages) {
            STACK inserted = storage.insert(this.createStack(this.chemical, remaining), Action.EXECUTE);
            remaining -= inserted.getAmount();
        }
    }

    @Override
    public JsonObject debugInput(Level level, RecipeStorages storages, JsonObject json) {
        List<MekanismChemicalPortStorage<CHEMICAL, STACK>> inputStorages = storages.getInputStorages(this.getStorageClass());
        JsonArray searchedStoragesJson = new JsonArray();
        json.addProperty("ingredientType", this.getTypeId().toString());
        json.addProperty("amountToInsert", (Number)this.amount);
        long remaining = this.amount;
        for (MekanismChemicalPortStorage<CHEMICAL, STACK> storage : inputStorages) {
            STACK extracted = storage.extract(remaining, Action.SIMULATE);
            remaining -= extracted.getAmount();
            searchedStoragesJson.add(storage.getStorageUid().toString());
        }
        json.addProperty("canRun", Boolean.valueOf(remaining <= 0L));
        json.add("searchedStorages", (JsonElement)searchedStoragesJson);
        return json;
    }

    @Override
    public JsonObject debugOutput(Level level, RecipeStorages storages, JsonObject json) {
        List<MekanismChemicalPortStorage<CHEMICAL, STACK>> outputStorages = storages.getOutputStorages(this.getStorageClass());
        JsonArray searchedStoragesJson = new JsonArray();
        json.addProperty("ingredientType", this.getTypeId().toString());
        json.addProperty("amountToInsert", (Number)this.amount);
        long remaining = this.amount;
        for (MekanismChemicalPortStorage<CHEMICAL, STACK> storage : outputStorages) {
            STACK inserted = storage.insert(this.createStack(this.chemical, remaining), Action.SIMULATE);
            remaining -= inserted.getAmount();
            searchedStoragesJson.add(storage.getStorageUid().toString());
        }
        json.addProperty("canRun", Boolean.valueOf(remaining <= 0L));
        json.add("searchedStorages", (JsonElement)searchedStoragesJson);
        return json;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeModel model, IFocusGroup focus, IJeiHelpers helpers, SlotGrid grid, IRecipeSlotBuilder recipeSlot) {
        recipeSlot.addTooltipCallback((a, c) -> c.add(1, Component.m_237113_((String)(this.amount + " mB"))));
    }
}

