/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.pneumaticcraft.air.register;

import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortBlockEntity;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.pneumaticcraft.air.PneumaticAirPortStorage;
import io.ticticboom.mods.mm.port.pneumaticcraft.air.PneumaticAirPortStorageModel;
import io.ticticboom.mods.mm.port.pneumaticcraft.air.register.PneumaticAirPortMenu;
import io.ticticboom.mods.mm.setup.RegistryGroupHolder;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.AssemblyProgramItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PneumaticAirPortBlockEntity
extends AbstractTickingBlockEntity
implements IPortBlockEntity {
    private final PortModel model;
    private final RegistryGroupHolder groupHolder;
    private final boolean isInput;
    private final PneumaticAirPortStorage storage;
    private final ItemStackHandler itemHandler = new BaseItemStackHandler((BlockEntity)this, 1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.m_41619_() || itemStack.m_41720_() instanceof AssemblyProgramItem;
        }
    };

    public PneumaticAirPortBlockEntity(PortModel model, RegistryGroupHolder groupHolder, boolean isInput, BlockPos pos, BlockState state) {
        super((BlockEntityType)groupHolder.getBe().get(), pos, state);
        this.model = model;
        this.groupHolder = groupHolder;
        this.isInput = isInput;
        this.storage = (PneumaticAirPortStorage)model.config().createPortStorage(this::m_6596_);
    }

    @Override
    public IPortStorage getStorage() {
        return this.storage;
    }

    public PneumaticAirPortStorageModel getStorageModel() {
        return (PneumaticAirPortStorageModel)this.storage.getStorageModel();
    }

    @Override
    public boolean isInput() {
        return this.isInput;
    }

    @Override
    public PortModel getModel() {
        return this.model;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Pncr Air Port");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new PneumaticAirPortMenu(this.model, this.groupHolder, this.isInput, windowId, inv, this);
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap != PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY) {
            return super.getCapability(cap, side);
        }
        return this.storage.getCapability(cap);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6596_() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        super.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_(Ref.NBT_STORAGE_KEY, (Tag)this.storage.save(new CompoundTag()));
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        this.storage.load(tag.m_128469_(Ref.NBT_STORAGE_KEY));
        super.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onNeighborBlockUpdate(BlockPos fromPos) {
        this.m_6596_();
        super.onNeighborBlockUpdate(fromPos);
        this.storage.onNeighborBlockUpdate();
    }

    public void tickCommonPre() {
        super.tickCommonPre();
        this.storage.airHandlerMap.keySet().forEach(handler -> handler.tick((BlockEntity)this));
    }
}

