/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.structure.layout;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.port.IPortBlockEntity;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import io.ticticboom.mods.mm.structure.StructureModel;
import io.ticticboom.mods.mm.structure.layout.PositionedLayoutPiece;
import io.ticticboom.mods.mm.structure.layout.StructureCharacterGrid;
import io.ticticboom.mods.mm.structure.layout.StructureKeyChar;
import io.ticticboom.mods.mm.structure.layout.StructureLayoutPiece;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.util.TriConsumer;

public class StructureLayout {
    private StructureCharacterGrid charGrid;
    private List<PositionedLayoutPiece> positionedPieces = new ArrayList<PositionedLayoutPiece>();
    Map<Rotation, List<PositionedLayoutPiece>> rotatedPositionedPieces = new HashMap<Rotation, List<PositionedLayoutPiece>>();
    private Map<StructureKeyChar, StructureLayoutPiece> pieces;

    public StructureLayout(StructureCharacterGrid rawLayout, Map<StructureKeyChar, StructureLayoutPiece> pieces) {
        this.charGrid = rawLayout;
        this.pieces = pieces;
        this.setupVariants();
    }

    public void setupVariants() {
        this.charGrid.runFor((TriConsumer<BlockPos, BlockPos, StructureKeyChar>)((TriConsumer)(pos, cPos, chr) -> {
            StructureLayoutPiece piece = this.pieces.get(chr);
            this.positionedPieces.add(new PositionedLayoutPiece(pos.m_121996_((Vec3i)cPos), piece));
        }));
        this.rotatedPositionedPieces.put(Rotation.NONE, this.positionedPieces);
        for (Rotation rotation : Rotation.values()) {
            ArrayList<PositionedLayoutPiece> rotatedPieces = new ArrayList<PositionedLayoutPiece>();
            for (PositionedLayoutPiece piece : this.positionedPieces) {
                rotatedPieces.add(piece.rotate(rotation));
            }
            this.rotatedPositionedPieces.put(rotation, rotatedPieces);
        }
    }

    public boolean formed(Level level, BlockPos worldControllerPos, StructureModel model) {
        for (Map.Entry<Rotation, List<PositionedLayoutPiece>> entry : this.rotatedPositionedPieces.entrySet()) {
            if (!this.innerFormed(level, worldControllerPos, model, entry.getValue(), entry.getKey())) continue;
            return true;
        }
        return false;
    }

    public JsonObject debugFormed(Level level, BlockPos worldControllerPos, StructureModel model) {
        JsonObject json = new JsonObject();
        for (Map.Entry<Rotation, List<PositionedLayoutPiece>> entry : this.rotatedPositionedPieces.entrySet()) {
            json.add(entry.getKey().name(), (JsonElement)this.debugInnerFormed(level, worldControllerPos, model, entry.getValue(), entry.getKey()));
        }
        return json;
    }

    public JsonObject debugInnerFormed(Level level, BlockPos worldControllerPos, StructureModel model, List<PositionedLayoutPiece> positionedPieces, Rotation rot) {
        JsonObject json = new JsonObject();
        json.addProperty("formed", Boolean.valueOf(this.innerFormed(level, worldControllerPos, model, positionedPieces, rot)));
        json.addProperty("rotation", rot.name());
        JsonArray piecesJson = new JsonArray();
        for (PositionedLayoutPiece positionedPiece : positionedPieces) {
            JsonObject pieceJson = positionedPiece.piece().debugFormed(level, worldControllerPos, model, rot);
            piecesJson.add((JsonElement)pieceJson);
        }
        json.add("pieces", (JsonElement)piecesJson);
        return json;
    }

    public void validate(StructureModel model) {
        for (StructureLayoutPiece value : this.pieces.values()) {
            value.validate(model);
        }
    }

    private boolean innerFormed(Level level, BlockPos worldControllerPos, StructureModel model, List<PositionedLayoutPiece> positionedPieces, Rotation rot) {
        for (PositionedLayoutPiece piece : positionedPieces) {
            if (piece.formed(level, worldControllerPos, model, rot)) continue;
            return false;
        }
        return true;
    }

    public RecipeStorages getRecipeStorages(Level level, BlockPos worldControllerPos, StructureModel model) {
        for (Map.Entry<Rotation, List<PositionedLayoutPiece>> entry : this.rotatedPositionedPieces.entrySet()) {
            if (!this.innerFormed(level, worldControllerPos, model, entry.getValue(), entry.getKey())) continue;
            return this.innerGetRecipeStorages(level, worldControllerPos, entry.getValue());
        }
        return null;
    }

    private RecipeStorages innerGetRecipeStorages(Level level, BlockPos worldControllerPos, List<PositionedLayoutPiece> positionedPieces) {
        ArrayList<IPortStorage> inputStorages = new ArrayList<IPortStorage>();
        ArrayList<IPortStorage> outputStorages = new ArrayList<IPortStorage>();
        for (PositionedLayoutPiece positionedPiece : positionedPieces) {
            BlockPos absolutePos = positionedPiece.findAbsolutePos(worldControllerPos);
            BlockEntity be = level.m_7702_(absolutePos);
            if (!(be instanceof IPortBlockEntity)) continue;
            IPortBlockEntity pbe = (IPortBlockEntity)be;
            if (pbe.isInput()) {
                inputStorages.add(pbe.getStorage());
                continue;
            }
            outputStorages.add(pbe.getStorage());
        }
        return new RecipeStorages(inputStorages, outputStorages);
    }

    public static StructureLayout parse(JsonObject json, ResourceLocation structureId) {
        StructureCharacterGrid raw = StructureLayout.getCharGrid(json);
        Map<StructureKeyChar, StructureLayoutPiece> pieces = StructureLayout.getPieces(json, structureId);
        return new StructureLayout(raw, pieces);
    }

    public JsonObject serialize(JsonObject json) {
        json.add("layout", (JsonElement)this.charGrid.serialize());
        JsonObject key = new JsonObject();
        for (Map.Entry<StructureKeyChar, StructureLayoutPiece> entry : this.pieces.entrySet()) {
            key.add("" + entry.getKey().character(), (JsonElement)entry.getValue().getJson());
        }
        json.add("key", (JsonElement)key);
        return json;
    }

    public void setup(ResourceLocation structureId) {
        for (StructureLayoutPiece value : this.pieces.values()) {
            value.setup(structureId);
        }
    }

    private static Map<StructureKeyChar, StructureLayoutPiece> getPieces(JsonObject json, ResourceLocation structureId) {
        HashMap<StructureKeyChar, StructureLayoutPiece> pieces = new HashMap<StructureKeyChar, StructureLayoutPiece>();
        for (Map.Entry key : json.getAsJsonObject("key").asMap().entrySet()) {
            JsonObject jsonKey = ((JsonElement)key.getValue()).getAsJsonObject();
            pieces.put(new StructureKeyChar(((String)key.getKey()).charAt(0)), StructureLayoutPiece.parse(jsonKey, structureId, (String)key.getKey()));
        }
        return pieces;
    }

    private static StructureCharacterGrid getCharGrid(JsonObject json) {
        ArrayList<List<String>> rawLayout = new ArrayList<List<String>>();
        JsonArray layers = json.get("layout").getAsJsonArray();
        for (JsonElement layer : layers) {
            ArrayList<String> resultRows = new ArrayList<String>();
            JsonArray rows = layer.getAsJsonArray();
            for (JsonElement row : rows) {
                resultRows.add(row.getAsString());
            }
            rawLayout.add(resultRows);
        }
        return new StructureCharacterGrid(rawLayout);
    }

    public StructureCharacterGrid getCharGrid() {
        return this.charGrid;
    }

    public List<PositionedLayoutPiece> getPositionedPieces() {
        return this.positionedPieces;
    }

    public Map<Rotation, List<PositionedLayoutPiece>> getRotatedPositionedPieces() {
        return this.rotatedPositionedPieces;
    }

    public Map<StructureKeyChar, StructureLayoutPiece> getPieces() {
        return this.pieces;
    }
}

