/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.client.util;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraftforge.client.extensions.IForgeFont;

public class TextRenderUtil {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static FormattedText ellipsizeAlways(Font font, FormattedText text, int maxWidth) {
        int strWidth = font.m_92852_(text);
        int ellipsisWidth = font.m_92852_(IForgeFont.ELLIPSIS);
        if (strWidth > maxWidth) {
            return FormattedText.m_130773_((FormattedText[])new FormattedText[]{font.m_92854_(text, maxWidth - ellipsisWidth), IForgeFont.ELLIPSIS});
        }
        if (strWidth + ellipsisWidth > maxWidth) {
            return FormattedText.m_130773_((FormattedText[])new FormattedText[]{font.m_92854_(text, maxWidth - ellipsisWidth), IForgeFont.ELLIPSIS});
        }
        return FormattedText.m_130773_((FormattedText[])new FormattedText[]{text, IForgeFont.ELLIPSIS});
    }

    public static void renderWordWrapLimit(GuiGraphics guiGraphics, Font font, FormattedText text, int x, int y, int lineWidth, int lineLimit, int color) {
        Objects.requireNonNull(font);
        int lineHeight = 9;
        List split = font.m_92865_().m_92414_(text, lineWidth, Style.f_131099_);
        for (int i = 0; i < split.size(); ++i) {
            boolean isLimit = i == lineLimit - 1;
            boolean isEnd = i == split.size() - 1;
            FormattedText lineText = (FormattedText)split.get(i);
            if (isLimit && !isEnd) {
                lineText = TextRenderUtil.ellipsizeAlways(font, lineText, lineWidth);
            }
            guiGraphics.m_280056_(font, lineText.getString(), x, y, color, false);
            y += lineHeight;
            if (isLimit) break;
        }
    }

    public static void renderWordWrapLimit(GuiGraphics guiGraphics, FormattedText text, int x, int y, int lineWidth, int lineLimit, int color) {
        TextRenderUtil.renderWordWrapLimit(guiGraphics, TextRenderUtil.mc.f_91062_, text, x, y, lineWidth, lineLimit, color);
    }

    public static void renderWordWrapLimit(GuiGraphics guiGraphics, String text, int x, int y, int lineWidth, int lineLimit, int color) {
        FormattedText fText = FormattedText.m_130775_((String)text);
        TextRenderUtil.renderWordWrapLimit(guiGraphics, fText, x, y, lineWidth, lineLimit, color);
    }
}

