/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.compat.kjs.builder;

import dev.latvian.mods.rhino.util.HideFromJS;
import io.ticticboom.mods.mm.compat.kjs.builder.PortConfigBuilderJS;
import io.ticticboom.mods.mm.model.IdList;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortStorageFactory;
import io.ticticboom.mods.mm.port.MMPortRegistry;
import io.ticticboom.mods.mm.port.PortType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class PortBuilderJS {
    private final String id;
    private ResourceLocation type;
    private String name;
    private final List<ResourceLocation> controllers = new ArrayList<ResourceLocation>();
    private Consumer<PortConfigBuilderJS> builder;

    @HideFromJS
    public PortBuilderJS(String id) {
        this.id = id;
    }

    public PortBuilderJS name(String name) {
        this.name = name;
        return this;
    }

    public PortBuilderJS controllerId(String controllerId) {
        this.controllers.add(new ResourceLocation(controllerId));
        return this;
    }

    public PortBuilderJS config(String type, Consumer<PortConfigBuilderJS> builder) {
        this.type = new ResourceLocation(type);
        this.builder = builder;
        return this;
    }

    @HideFromJS
    public List<PortModel> build() {
        PortType portType = MMPortRegistry.get(this.type);
        IPortStorageFactory storageFactory = portType.createStorageFactory(this.builder);
        IdList controllerIds = new IdList(this.controllers);
        PortModel inputPort = PortModel.create(this.id, this.name, controllerIds, this.type, storageFactory, true);
        PortModel outputPort = PortModel.create(this.id, this.name, controllerIds, this.type, storageFactory, false);
        return List.of(inputPort, outputPort);
    }

    public String getId() {
        return this.id;
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<ResourceLocation> getControllers() {
        return this.controllers;
    }

    public Consumer<PortConfigBuilderJS> getBuilder() {
        return this.builder;
    }
}

