/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.debug.output;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.controller.machine.register.MachineControllerBlockEntity;
import io.ticticboom.mods.mm.debug.output.CollectedDebugData;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.MMPortRegistry;
import io.ticticboom.mods.mm.recipe.MachineRecipeManager;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import io.ticticboom.mods.mm.structure.StructureManager;
import io.ticticboom.mods.mm.structure.StructureModel;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.loading.FMLPaths;

public class DebugOutputManager {
    public static CollectedDebugData collect(Level level, BlockPos pos) {
        CollectedDebugData data = new CollectedDebugData();
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MachineControllerBlockEntity) {
            MachineControllerBlockEntity cbe = (MachineControllerBlockEntity)be;
            data.setControllerDef(cbe.getModel());
            data.setPortDefs(MMPortRegistry.getPortModelsForControllerId(Ref.id(cbe.getModel().id())));
            ResourceLocation controllerId = Ref.id(data.getControllerDef().id());
            data.setStructureDefs(StructureManager.getStructuresForController(controllerId));
            data.setRecipeDefs(MachineRecipeManager.getRecipeForStructureIds(data.getStructureIds()));
            HashMap<ResourceLocation, RecipeStorages> storagesMap = new HashMap<ResourceLocation, RecipeStorages>();
            for (StructureModel structureDef : data.structureDefs) {
                JsonObject json = structureDef.debugFormed(level, pos);
                json.addProperty("_path", structureDef.debugPath());
                data.addStructureState(json);
                RecipeStorages storages = structureDef.getStorages(level, pos);
                storagesMap.put(structureDef.id(), storages);
            }
            for (RecipeModel recipeDef : data.recipeDefs) {
                JsonObject json;
                RecipeStorages storages = storagesMap.getOrDefault(recipeDef.structureId(), null);
                if (storages != null) {
                    json = recipeDef.debugRun(level, new RecipeStateModel(), storages);
                    json.addProperty("_path", recipeDef.debugPath());
                    data.addRecipeState(json);
                    continue;
                }
                json = new JsonObject();
                json.addProperty("_path", recipeDef.debugPath());
                json.addProperty("noStorages", Boolean.valueOf(true));
                json.addProperty("_comment", "No Port Storages were stored for this recipe. This could suggest a mismatch in ids or references somewhere.");
                data.addRecipeState(json);
            }
        }
        data.diags.addProperty("javaVersion", System.getProperty("java.version"));
        data.diags.addProperty("javaVendor", System.getProperty("java.vendor"));
        data.diags.addProperty("osName", System.getProperty("os.name"));
        data.diags.addProperty("osVersion", System.getProperty("os.version"));
        data.diags.addProperty("osArch", System.getProperty("os.arch"));
        data.diags.addProperty("availProcessors", (Number)Runtime.getRuntime().availableProcessors());
        data.diags.addProperty("freeMemory", (Number)Runtime.getRuntime().freeMemory());
        data.diags.addProperty("maxMemory", (Number)Runtime.getRuntime().maxMemory());
        data.diags.addProperty("totalMemory", (Number)Runtime.getRuntime().totalMemory());
        return data;
    }

    public static String output(CollectedDebugData data) {
        String string;
        File file = DebugOutputManager.getOutputFile();
        FileOutputStream fout = new FileOutputStream(file);
        ZipOutputStream zip = new ZipOutputStream(fout);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (JsonObject structureState : data.structureStates) {
            zip.putNextEntry(new ZipEntry("structure_states/" + structureState.get("_path").getAsString()));
            string = gson.toJson((JsonElement)structureState);
            zip.write(string.getBytes(StandardCharsets.UTF_8));
            zip.closeEntry();
        }
        for (JsonObject recipeState : data.getRecipeStates()) {
            zip.putNextEntry(new ZipEntry("recipe_states/" + recipeState.get("_path").getAsString()));
            string = gson.toJson((JsonElement)recipeState);
            zip.write(string.getBytes(StandardCharsets.UTF_8));
            zip.closeEntry();
        }
        for (StructureModel structureDef : data.structureDefs) {
            zip.putNextEntry(new ZipEntry("structures/" + structureDef.debugPath()));
            string = gson.toJson((JsonElement)structureDef.getConfig());
            zip.write(string.getBytes(StandardCharsets.UTF_8));
            zip.closeEntry();
        }
        for (RecipeModel recipeDef : data.recipeDefs) {
            zip.putNextEntry(new ZipEntry("recipes/" + recipeDef.debugPath()));
            string = gson.toJson((JsonElement)recipeDef.config());
            zip.write(string.getBytes(StandardCharsets.UTF_8));
            zip.closeEntry();
        }
        for (PortModel portDef : data.portDefs) {
            zip.putNextEntry(new ZipEntry("ports/" + portDef.id() + ".json"));
            string = gson.toJson((JsonElement)portDef.jsonConfig());
            zip.write(string.getBytes(StandardCharsets.UTF_8));
            zip.closeEntry();
        }
        zip.putNextEntry(new ZipEntry("system-diags.json"));
        zip.write(gson.toJson((JsonElement)data.diags).getBytes(StandardCharsets.UTF_8));
        zip.closeEntry();
        zip.putNextEntry(new ZipEntry("controller.json"));
        zip.write(gson.toJson((JsonElement)data.controllerDef.config()).getBytes(StandardCharsets.UTF_8));
        zip.closeEntry();
        zip.close();
        return file.getAbsolutePath();
    }

    private static File getOutputFile() {
        Path dir = FMLPaths.CONFIGDIR.get().resolve("mm/dumps");
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        long date = new Date().toInstant().toEpochMilli();
        String fName = "mmdump-" + date + ".zip";
        return dir.resolve(fName).toFile();
    }
}

