/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.piece;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.piece.modifier.MMStructurePieceModifierType;
import io.ticticboom.mods.mm.piece.modifier.StructurePieceModifier;
import io.ticticboom.mods.mm.piece.modifier.blockstate.BlockstateStructurePieceModifierType;
import io.ticticboom.mods.mm.piece.type.MMStructurePieceType;
import io.ticticboom.mods.mm.piece.type.StructurePiece;
import io.ticticboom.mods.mm.piece.type.block.BlockStructurePieceType;
import io.ticticboom.mods.mm.piece.type.port.PortStructurePieceType;
import io.ticticboom.mods.mm.piece.type.porttype.PortTypeStructurePieceType;
import io.ticticboom.mods.mm.piece.type.states.StatesStructurePieceType;
import io.ticticboom.mods.mm.piece.type.tag.TagStructurePieceType;
import java.util.ArrayList;
import java.util.List;

public class MMStructurePieceRegistry {
    private static List<MMStructurePieceType> PIECE_TYPES = new ArrayList<MMStructurePieceType>();
    private static List<MMStructurePieceModifierType> MODIFIER_TYPES = new ArrayList<MMStructurePieceModifierType>();

    public static void registerPiece(MMStructurePieceType piece) {
        PIECE_TYPES.add(piece);
    }

    public static void registerModifier(MMStructurePieceModifierType modifier) {
        MODIFIER_TYPES.add(modifier);
    }

    public static StructurePiece findPieceType(JsonObject json) {
        for (MMStructurePieceType pieceType : PIECE_TYPES) {
            if (!pieceType.identify(json)) continue;
            return pieceType.parse(json);
        }
        return null;
    }

    public static List<StructurePieceModifier> findModifierTypes(JsonObject json) {
        ArrayList<StructurePieceModifier> result = new ArrayList<StructurePieceModifier>();
        for (MMStructurePieceModifierType modifierType : MODIFIER_TYPES) {
            if (!modifierType.identify(json)) continue;
            result.add(modifierType.parse(json));
        }
        return result;
    }

    public static void init() {
        MMStructurePieceRegistry.registerPiece(new BlockStructurePieceType());
        MMStructurePieceRegistry.registerPiece(new TagStructurePieceType());
        MMStructurePieceRegistry.registerPiece(new PortStructurePieceType());
        MMStructurePieceRegistry.registerPiece(new PortTypeStructurePieceType());
        MMStructurePieceRegistry.registerPiece(new StatesStructurePieceType());
        MMStructurePieceRegistry.registerModifier(new BlockstateStructurePieceModifierType());
    }
}

