/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.piece.modifier.blockstate;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.piece.StructurePieceSetupMetadata;
import io.ticticboom.mods.mm.piece.modifier.StructurePieceModifier;
import io.ticticboom.mods.mm.piece.modifier.blockstate.StructureBlockstateProperty;
import io.ticticboom.mods.mm.structure.StructureModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockstateStructurePieceModifier
extends StructurePieceModifier {
    private final String id;
    private final List<StructureBlockstateProperty> properties;
    private final Map<String, Property.Value<?>> propValues = new HashMap();

    public BlockstateStructurePieceModifier(String id, List<StructureBlockstateProperty> properties) {
        this.id = id;
        this.properties = properties;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void validateSetup(StructurePieceSetupMetadata meta, List<Block> requiredBlocks) {
        for (Block requiredBlock : requiredBlocks) {
            StateDefinition stateDefinition = requiredBlock.m_49965_();
            for (StructureBlockstateProperty property : this.properties) {
                Property prop = stateDefinition.m_61081_(property.key());
                Property.Value val = (Property.Value)((Pair)((DataResult)JsonOps.INSTANCE.withDecoder((Decoder)prop.m_61705_()).apply(property.value())).getOrThrow(false, RuntimeException::new)).getFirst();
                this.propValues.put(prop.m_61708_(), val);
            }
        }
    }

    @Override
    public boolean formed(Level level, BlockPos pos, StructureModel model, Rotation rotation) {
        BlockState blockState = level.m_8055_(pos);
        AtomicInteger matched = new AtomicInteger();
        for (Property.Value<?> value : this.propValues.values()) {
            Optional prop = blockState.m_61145_(value.f_61712_());
            prop.ifPresent(v -> {
                if (v.equals(value.f_61713_())) {
                    matched.getAndIncrement();
                }
            });
        }
        return matched.get() >= this.properties.size();
    }

    @Override
    public BlockState modifyBlockState(BlockState state, BlockEntity be, BlockPos pos) {
        return this.modifyBlockstate(state);
    }

    @Override
    public BlockEntity modifyBlockEntity(BlockState state, BlockEntity be, BlockPos pos) {
        return be;
    }

    @Override
    public JsonObject debugExpected(Level level, BlockPos pos, StructureModel model, Rotation rotation, JsonObject json) {
        JsonArray propsJson = new JsonArray();
        for (StructureBlockstateProperty property : this.properties) {
            JsonObject propertyJson = new JsonObject();
            propertyJson.addProperty("property", property.key());
            propertyJson.add("value", property.value());
            propsJson.add((JsonElement)propertyJson);
        }
        return json;
    }

    @Override
    public JsonObject debugFound(Level level, BlockPos pos, StructureModel model, Rotation rotation, JsonObject json) {
        BlockState blockstate = level.m_8055_(pos);
        Optional res = ((DataResult)JsonOps.INSTANCE.withEncoder((Encoder)BlockState.f_61039_).apply(blockstate)).result();
        if (res.isPresent()) {
            json.add("blockstate", (JsonElement)res.get());
        } else {
            json.addProperty("failedToSerializeBlockState", Boolean.valueOf(true));
        }
        return json;
    }

    private BlockState modifyBlockstate(BlockState state) {
        JsonElement encoded = (JsonElement)((DataResult)JsonOps.INSTANCE.withEncoder((Encoder)BlockState.f_61039_).apply(state)).getOrThrow(false, RuntimeException::new);
        JsonObject jsonProps = encoded.getAsJsonObject().get("Properties").getAsJsonObject();
        for (StructureBlockstateProperty property : this.properties) {
            jsonProps.add(property.key(), property.value());
        }
        Ref.LOG.info(encoded.toString());
        BlockState result = (BlockState)((Pair)((DataResult)JsonOps.INSTANCE.withDecoder((Decoder)BlockState.f_61039_).apply(encoded)).getOrThrow(false, RuntimeException::new)).getFirst();
        return result;
    }
}

