/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.piece.type.port;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.piece.StructurePieceSetupMetadata;
import io.ticticboom.mods.mm.piece.type.StructurePiece;
import io.ticticboom.mods.mm.port.IPortBlock;
import io.ticticboom.mods.mm.port.IPortBlockEntity;
import io.ticticboom.mods.mm.port.MMPortRegistry;
import io.ticticboom.mods.mm.setup.RegistryGroupHolder;
import io.ticticboom.mods.mm.structure.StructureModel;
import io.ticticboom.mods.mm.util.PortUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class PortStructurePiece
extends StructurePiece {
    private final ResourceLocation portId;
    private final Optional<Boolean> input;
    private final List<Block> blocks = new ArrayList<Block>();

    public PortStructurePiece(ResourceLocation portId, Optional<Boolean> input) {
        this.portId = portId;
        this.input = input;
    }

    @Override
    public void validateSetup(StructurePieceSetupMetadata meta) {
        for (RegistryGroupHolder port : MMPortRegistry.PORTS) {
            IPortBlock pb;
            PortModel model;
            Object object = port.getBlock().get();
            if (!(object instanceof IPortBlock) || !(model = (pb = (IPortBlock)object).getModel()).id().equals(PortUtils.id(this.portId.m_135815_(), model.input())) || this.input.isPresent() && !this.input.get().equals(model.input())) continue;
            this.blocks.add((Block)port.getBlock().get());
        }
    }

    @Override
    public boolean formed(Level level, BlockPos pos, StructureModel model) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof IPortBlockEntity) {
            IPortBlockEntity pbe = (IPortBlockEntity)be;
            if (!pbe.getModel().id().equals(PortUtils.id(this.portId.m_135815_(), pbe.getModel().input()))) {
                return false;
            }
            return !this.input.isPresent() || this.input.get().equals(pbe.getModel().input());
        }
        return false;
    }

    @Override
    public Supplier<List<Block>> createBlocksSupplier() {
        return () -> this.blocks;
    }

    @Override
    public Component createDisplayComponent() {
        return Component.m_237113_((String)"Port: ").m_7220_((Component)Component.m_237113_((String)this.portId.toString()).m_130940_(ChatFormatting.DARK_AQUA));
    }

    @Override
    public JsonObject debugExpected(Level level, BlockPos pos, StructureModel model, JsonObject json) {
        json.addProperty("portId", this.portId.toString());
        json.addProperty("requiresIOCheck", Boolean.valueOf(this.input.isPresent()));
        this.input.ifPresent(aBoolean -> json.addProperty("isInput", aBoolean));
        return json;
    }

    @Override
    public JsonObject debugFound(Level level, BlockPos pos, StructureModel model, JsonObject json) {
        Block foundBlock = level.m_8055_(pos).m_60734_();
        ResourceLocation foundBlockId = ForgeRegistries.BLOCKS.getKey((Object)foundBlock);
        json.addProperty("block", foundBlockId.toString());
        if (foundBlock instanceof IPortBlock) {
            IPortBlock pb = (IPortBlock)foundBlock;
            json.addProperty("isPort", Boolean.valueOf(true));
            ResourceLocation portType = pb.getModel().type();
            json.addProperty("portTypeId", portType.toString());
            json.addProperty("portId", Ref.id(pb.getModel().id()).toString());
            json.addProperty("isInput", Boolean.valueOf(pb.getModel().input()));
        } else {
            json.addProperty("isPort", Boolean.valueOf(false));
        }
        return json;
    }
}

