/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.common;

import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.port.IPortBlockEntity;
import io.ticticboom.mods.mm.port.IPortMenu;
import io.ticticboom.mods.mm.port.IPortPart;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.common.ISlottedPortStorageModel;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.phys.Vec2;

public class SlottedContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected final T menu;
    protected final FormattedText header;
    protected ArrayList<Vec2> slots = new ArrayList();

    public SlottedContainerScreen(T menu, Inventory inv, Component displayName) {
        super(menu, inv, displayName);
        this.menu = menu;
        this.f_97727_ = 222;
        this.f_97726_ = 174;
        String name = ((IPortPart)menu).getModel().name();
        int subStrLength = Math.min(55, name.length());
        this.header = FormattedText.m_130775_((String)(name.substring(0, subStrLength) + (subStrLength < 55 ? "" : "...")));
        this.setupSlots();
    }

    private void setupSlots() {
        IPortBlockEntity blockEntity = (IPortBlockEntity)((IPortMenu)this.menu).getBlockEntity();
        IPortStorage storage = blockEntity.getStorage();
        ISlottedPortStorageModel model = (ISlottedPortStorageModel)storage.getStorageModel();
        int columns = model.columns();
        int rows = model.rows();
        int offsetX = (162 - columns * 18) / 2 + 7;
        int offsetY = (108 - rows * 18) / 2 + 7;
        this.slots.ensureCapacity(columns * rows);
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                this.slots.add(new Vec2((float)(x * 18 + offsetX), (float)(y * 18 + offsetY)));
            }
        }
    }

    protected void m_7286_(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        gfx.m_280218_(Ref.UiTextures.PORT_GUI, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (Vec2 slot : this.slots) {
            gfx.m_280218_(Ref.UiTextures.SLOT_PARTS, this.f_97735_ + (int)slot.f_82470_, this.f_97736_ + (int)slot.f_82471_, 0, 26, 18, 18);
        }
    }

    protected void m_280003_(GuiGraphics gfx, int mouseX, int mouseY) {
        gfx.m_280554_(this.f_96547_, this.header, 8, 8, 150, 0x404040);
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gfx);
        super.m_88315_(gfx, mouseX, mouseY, partialTicks);
        this.m_280072_(gfx, mouseX, mouseY);
    }
}

