/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.energy.register;

import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.common.AbstractPortAutoPushFeature;
import io.ticticboom.mods.mm.port.common.AbstractPortBlockEntity;
import io.ticticboom.mods.mm.port.energy.EnergyPortStorage;
import io.ticticboom.mods.mm.port.energy.EnergyPortStorageModel;
import io.ticticboom.mods.mm.port.energy.feature.EnergyPortAutoPushFeature;
import io.ticticboom.mods.mm.port.energy.register.EnergyPortMenu;
import io.ticticboom.mods.mm.setup.RegistryGroupHolder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyPortBlockEntity
extends AbstractPortBlockEntity {
    private final PortModel model;
    private final RegistryGroupHolder groupHolder;
    private final boolean isInput;
    private final EnergyPortStorage storage;
    private final Optional<EnergyPortAutoPushFeature> autoPushAddon;

    public EnergyPortBlockEntity(PortModel model, RegistryGroupHolder groupHolder, boolean isInput, BlockPos pos, BlockState state) {
        super((BlockEntityType)groupHolder.getBe().get(), pos, state);
        this.model = model;
        this.groupHolder = groupHolder;
        this.isInput = isInput;
        this.storage = (EnergyPortStorage)model.config().createPortStorage(this::m_6596_);
        boolean shouldAutoPush = !isInput && ((EnergyPortStorageModel)this.storage.getStorageModel()).autoPush().get() != false;
        this.autoPushAddon = shouldAutoPush ? Optional.of(new EnergyPortAutoPushFeature(this, this.model)) : Optional.empty();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return this.storage.getCapability(cap);
    }

    @Override
    public IPortStorage getStorage() {
        return this.storage;
    }

    public EnergyPortStorageModel getStorageModel() {
        return (EnergyPortStorageModel)this.storage.getStorageModel();
    }

    @Override
    public boolean isInput() {
        return this.isInput;
    }

    @Override
    public PortModel getModel() {
        return this.model;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Energy Port");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new EnergyPortMenu(this.model, this.groupHolder, this.isInput, windowId, inv, this);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_(Ref.NBT_STORAGE_KEY, (Tag)this.storage.save(new CompoundTag()));
        super.m_183515_(tag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.storage.load(tag.m_128469_(Ref.NBT_STORAGE_KEY));
        super.m_142466_(tag);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void m_6596_() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        super.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    public void tick() {
        this.autoPushAddon.ifPresent(EnergyPortAutoPushFeature::tick);
    }

    public void onLoad() {
        this.autoPushAddon.ifPresent(AbstractPortAutoPushFeature::onLoad);
    }

    public void neighborsChanged() {
        this.autoPushAddon.ifPresent(AbstractPortAutoPushFeature::tryAddNeighboringHandlers);
    }
}

