/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.fluid;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.compat.jei.SlotGrid;
import io.ticticboom.mods.mm.compat.jei.ingredient.MMJeiIngredients;
import io.ticticboom.mods.mm.port.IPortIngredient;
import io.ticticboom.mods.mm.port.fluid.FluidPortStorage;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidPortIngredient
implements IPortIngredient {
    private final ResourceLocation fluidId;
    private final int amount;
    private final Fluid fluid;

    public FluidPortIngredient(ResourceLocation fluidId, int amount) {
        this.fluidId = fluidId;
        this.amount = amount;
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
        if (this.fluid == null) {
            throw new RuntimeException(String.format("Could not find fluid [%s] which is required by an MM recipe", fluidId));
        }
    }

    @Override
    public boolean canProcess(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<FluidPortStorage> fluidStorages = storages.getInputStorages(FluidPortStorage.class);
        int remaining = this.amount;
        for (FluidPortStorage storage : fluidStorages) {
            FluidStack drained = storage.getHandler().drain(new FluidStack(this.fluid, remaining), IFluidHandler.FluidAction.SIMULATE);
            remaining -= drained.getAmount();
        }
        return remaining <= 0;
    }

    @Override
    public void process(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<FluidPortStorage> fluidStorages = storages.getInputStorages(FluidPortStorage.class);
        int remaining = this.amount;
        for (FluidPortStorage storage : fluidStorages) {
            FluidStack drained = storage.getHandler().drain(new FluidStack(this.fluid, remaining), IFluidHandler.FluidAction.EXECUTE);
            remaining -= drained.getAmount();
        }
    }

    @Override
    public boolean canOutput(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<FluidPortStorage> fluidStorages = storages.getOutputStorages(FluidPortStorage.class);
        int remaining = this.amount;
        for (FluidPortStorage storage : fluidStorages) {
            int filled = storage.getHandler().fill(new FluidStack(this.fluid, remaining), IFluidHandler.FluidAction.SIMULATE);
            remaining -= filled;
        }
        return remaining <= 0;
    }

    @Override
    public void output(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<FluidPortStorage> fluidStorages = storages.getOutputStorages(FluidPortStorage.class);
        int remaining = this.amount;
        for (FluidPortStorage storage : fluidStorages) {
            int filled = storage.getHandler().fill(new FluidStack(this.fluid, remaining), IFluidHandler.FluidAction.EXECUTE);
            remaining -= filled;
        }
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeModel model, IFocusGroup focus, IJeiHelpers helpers, SlotGrid grid, IRecipeSlotBuilder recipeSlot) {
        recipeSlot.addIngredient(MMJeiIngredients.FLUID, (Object)new FluidStack(this.fluid, this.amount));
        recipeSlot.addTooltipCallback((a, b) -> b.add(1, Component.m_237113_((String)(this.amount + " mB"))));
    }

    @Override
    public JsonObject debugInput(Level level, RecipeStorages storages, JsonObject json) {
        List<FluidPortStorage> fluidStorages = storages.getInputStorages(FluidPortStorage.class);
        JsonArray searchedStorages = new JsonArray();
        JsonArray searchIterations = new JsonArray();
        json.addProperty("ingredientType", Ref.Ports.FLUID.toString());
        json.addProperty("amountToDrain", (Number)this.amount);
        int remaining = this.amount;
        for (FluidPortStorage storage : fluidStorages) {
            JsonObject iterJson = new JsonObject();
            FluidStack drained = storage.getHandler().drain(new FluidStack(this.fluid, remaining), IFluidHandler.FluidAction.SIMULATE);
            remaining -= drained.getAmount();
            DataResult drainedRes = (DataResult)JsonOps.INSTANCE.withEncoder((Encoder)FluidStack.CODEC).apply(drained);
            if (drainedRes.result().isPresent()) {
                iterJson.add("drainedFluidStack", (JsonElement)drainedRes.result().get());
            } else {
                iterJson.addProperty("failedToSerializeFluidStack", Boolean.valueOf(true));
            }
            iterJson.addProperty("drainedAmount", (Number)drained.getAmount());
            iterJson.addProperty("remainingToDrain", (Number)remaining);
            iterJson.addProperty("storageUid", storage.getStorageUid().toString());
            searchIterations.add((JsonElement)iterJson);
            searchedStorages.add(storage.getStorageUid().toString());
        }
        json.add("drainIterations", (JsonElement)searchIterations);
        json.addProperty("canRun", Boolean.valueOf(remaining <= 0));
        json.add("searchedStorages", (JsonElement)searchedStorages);
        return json;
    }

    @Override
    public JsonObject debugOutput(Level level, RecipeStorages storages, JsonObject json) {
        List<FluidPortStorage> fluidStorages = storages.getOutputStorages(FluidPortStorage.class);
        JsonArray searchedStorages = new JsonArray();
        JsonArray searchIterations = new JsonArray();
        json.addProperty("ingredientType", Ref.Ports.FLUID.toString());
        json.addProperty("amountToFill", (Number)this.amount);
        int remaining = this.amount;
        for (FluidPortStorage storage : fluidStorages) {
            JsonObject iterJson = new JsonObject();
            int filled = storage.getHandler().fill(new FluidStack(this.fluid, remaining), IFluidHandler.FluidAction.SIMULATE);
            iterJson.addProperty("filledAmount", (Number)filled);
            iterJson.addProperty("remainingToFill", (Number)(remaining -= filled));
            iterJson.addProperty("storageUid", storage.getStorageUid().toString());
            searchIterations.add((JsonElement)iterJson);
            searchedStorages.add(storage.getStorageUid().toString());
        }
        json.add("fillIterations", (JsonElement)searchIterations);
        json.addProperty("canRun", Boolean.valueOf(remaining <= 0));
        json.add("searchedStorages", (JsonElement)searchedStorages);
        return json;
    }
}

